
// sbs_rtl.h
// 02-10-2003 Sven B. Schreiber
// sbs@orgon.com

// =================================================================
// PROGRAM VERSION
// =================================================================

#define SBS_RTL_BUILD           6
#define SBS_RTL_VERSION_HIGH    1
#define SBS_RTL_VERSION_LOW     5

#define SBS_RTL_VERSION         ((SBS_RTL_VERSION_HIGH * 100) \
                                 + SBS_RTL_VERSION_LOW)

////////////////////////////////////////////////////////////////////
#ifdef _SBS_RTL_DLL_
////////////////////////////////////////////////////////////////////

// =================================================================
// PROGRAM IDENTIFICATION
// =================================================================

#define MAIN_BUILD              SBS_RTL_BUILD
#define MAIN_VERSION_HIGH       SBS_RTL_VERSION_HIGH
#define MAIN_VERSION_LOW        SBS_RTL_VERSION_LOW

// -----------------------------------------------------------------

#define MAIN_DAY                10
#define MAIN_MONTH              02
#define MAIN_YEAR               2003

// -----------------------------------------------------------------

#define MAIN_PREFIX             SBS
#define MAIN_MODULE             sbs_rtl
#define MAIN_NAME               SBS Runtime Library
#define MAIN_COMPANY            Sven B. Schreiber
#define MAIN_AUTHOR             Sven B. Schreiber
#define MAIN_EMAIL              sbs@orgon.com
#define MAIN_DLL

// =================================================================
// CONTROLS
// =================================================================

#define IDW_STATUSBAR           9999
#define IDT_TEXT1               9998
#define IDT_TEXT2               9997
#define IDT_TEXT3               9996
#define IDT_TEXT4               9995
#define IDI_ICON1               9994
#define IDI_ICON2               9993

////////////////////////////////////////////////////////////////////
#endif // #ifdef _SBS_RTL_DLL_
////////////////////////////////////////////////////////////////////

// =================================================================
// HEADER FILES
// =================================================================

#include <proginfo.h>

////////////////////////////////////////////////////////////////////
#ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// MORE HEADER FILES
// =================================================================

#include <commdlg.h>
#include <commctrl.h>
#include <lmcons.h>
#include <wininet.h>
#include <olectl.h>
#include <oleidl.h>
#include <ocidl.h>

// =================================================================
// MACROS
// =================================================================

#define IDIA(_t)              ((PBYTE) IDI_##_t)
#define IDIW(_t)              ((PWORD) IDI_##_t)

#define IDCA(_t)              ((PBYTE) IDC_##_t)
#define IDCW(_t)              ((PWORD) IDC_##_t)

#define LCASEA(_c)            ((BYTE) CharLowerA ((PBYTE) (_c)))
#define LCASEW(_c)            ((WORD) CharLowerW ((PWORD) (_c)))

#define UCASEA(_c)            ((BYTE) CharUpperA ((PBYTE) (_c)))
#define UCASEW(_c)            ((WORD) CharUpperW ((PWORD) (_c)))

#ifdef  UNICODE

#define IDI                   IDIW
#define IDC                   IDCW
#define LCASE                 LCASEW
#define UCASE                 UCASEW

#else   // #ifdef UNICODE

#define IDI                   IDIA
#define IDC                   IDCA
#define LCASE                 LCASEA
#define UCASE                 UCASEA

#endif  // #ifdef UNICODE

// -----------------------------------------------------------------

#define WS_WORKER_THREAD      (WS_POPUP | WS_SYSMENU | WS_DISABLED)

#define SBS_VERSION1(_v)      ((WORD) ((_v) >> 48))
#define SBS_VERSION2(_v)      ((WORD) ((_v) >> 32))
#define SBS_VERSION3(_v)      ((WORD) ((_v) >> 16))
#define SBS_VERSION4(_v)      ((WORD)  (_v)       )

#define TESTUNICODE(_u,_w,_a) ((_u) ? (PVOID) (_w) : (PVOID) (_a))

#define TESTNULL(_p,_v,_d)    ((_p) != NULL          ? (_v) : (_d))
#define TESTVOID(_p,_v,_d)    ((_p) != NULL && *(_p) ? (_v) : (_d))

#define SAFESTR(_p,_d)        TESTVOID ((_p),  (_p),     (_d))
#define SAFEPTR(_p,_d)        TESTNULL ((_p),  (_p),     (_d))
#define SAFEVAL(_p,_d)        TESTNULL ((_p), *(_p),     (_d))
#define SAFEMEMBER(_p,_m,_d)  TESTNULL ((_p),  (_p)->_m, (_d))

#define STRTOKEN(_s,_o,_c,_n) ((_s) != NULL ? (_o) : NULL), \
                              ((_s) != NULL ? (_s) : (_n)), \
                              ((_s) != NULL ? (_c) : NULL)

// -----------------------------------------------------------------

#define SBS_PRECT(_pr)                 \
        ((_pr)->left                ), \
        ((_pr)->top                 ), \
        ((_pr)->right  - (_pr)->left), \
        ((_pr)->bottom - (_pr)->top )

#define SBS_RECT(_r)               \
        ((_r).left              ), \
        ((_r).top               ), \
        ((_r).right  - (_r).left), \
        ((_r).bottom - (_r).top )

#define SBS_RECT_EX(_r,_n)                      \
        ((_r).left               +      (_n) ), \
        ((_r).top                +      (_n) ), \
        ((_r).right  - (_r).left - (2 * (_n))), \
        ((_r).bottom - (_r).top  - (2 * (_n)))

// -----------------------------------------------------------------

#define SBS_QTIME(_time)                          \
        (((QWORD) (_time).dwLowDateTime       ) | \
         ((QWORD) (_time).dwHighDateTime << 32))

#define SBS_SECONDS(_start,_now)                          \
        ((DWORD) ((SBS_QTIME (_now) - SBS_QTIME (_start)) \
                  / (QWORD) 10000000))

// -----------------------------------------------------------------

#define ENTRY(_a)        ((DWORD) ((PBYTE) ((_a)+1) - (PBYTE) (_a)))
#define OFFSET(_s,_m)    ((DWORD) &(((_s *) 0)->_m))
#define MEMBER(_s,_m)    sizeof (((_s *) 0)->_m)
#define SKIP(_p,_d)      ((PVOID) (((PBYTE) (_p)) + (_d)))
#define BACK(_p,_d)      ((PVOID) (((PBYTE) (_p)) - (_d)))
#define BASE(_p,_s,_m)   ((_s *) BACK (_p, OFFSET (_s, _m)))

#define COUNT(_n,_1,_x)  ((_n) == 1 ? (_1) : (_x))
#define COUNTX(_n,_1,_x) (_n), COUNT(_n,_1,_x)

// =================================================================
// WINDOW MESSAGES
// =================================================================

#define WM_APP_STARTUP   (WM_APP - 1)
#define WM_APP_CLEANUP   (WM_APP - 2)
#define WM_APP_INFO      (WM_APP - 3)
#define WM_APP_IDLE      (WM_APP - 4)
#define WM_APP_COMMAND   (WM_APP - 5)
#define WM_APP_MESSAGE   (WM_APP - 6)
#define WM_APP_TIMER     (WM_APP - 7)
#define WM_APP_NOTIFY    (WM_APP - 8)

// =================================================================
// STATUS CODE MACROS
// =================================================================

#define STATUS_SEVERITY_SUCCESS        0
#define STATUS_SEVERITY_INFORMATIONAL  1
#define STATUS_SEVERITY_WARNING        2
#define STATUS_SEVERITY_ERROR          3

#define STATUS_FACILITY_SBS            0
#define STATUS_FACILITY_USER           1

#define STATUS_CUSTOM(_s,_f,_c) \
        (((_s) << 30) | (1 << 29) | ((_f) << 16) | ((WORD) (_c)))

#define STATUS_CUSTOM_ERROR(_f,_c) \
        STATUS_CUSTOM (STATUS_SEVERITY_ERROR, (_f), (_c))

#define STATUS_CUSTOM_WARNING(_f,_c) \
        STATUS_CUSTOM (STATUS_SEVERITY_WARNING, (_f), (_c))

#define STATUS_CUSTOM_INFORMATIONAL(_f,_c) \
        STATUS_CUSTOM (STATUS_SEVERITY_INFORMATIONAL, (_f), (_c))

#define STATUS_SBS(_c) \
        STATUS_ERROR_CUSTOM (STATUS_FACILITY_SBS, (_c))

// =================================================================
// MESSAGEBOX MODE MACROS
// =================================================================

#define MB_EXTRA(_icon,_buttons) (MB_##_icon | MB_##_buttons)

// -----------------------------------------------------------------

#define MB_ERROR_OK \
        MB_EXTRA (ICONERROR, OK)

#define MB_ERROR_OKCANCEL \
        MB_EXTRA (ICONERROR, OKCANCEL)

#define MB_ERROR_ABORTRETRYIGNORE \
        MB_EXTRA (ICONERROR, ABORTRETRYIGNORE)

#define MB_ERROR_YESNOCANCEL \
        MB_EXTRA (ICONERROR, YESNOCANCEL)

#define MB_ERROR_YESNO \
        MB_EXTRA (ICONERROR, YESNO)

#define MB_ERROR_RETRYCANCEL \
        MB_EXTRA (ICONERROR, RETRYCANCEL)

#define MB_ERROR_CANCELTRYCONTINUE \
        MB_EXTRA (ICONERROR, CANCELTRYCONTINUE)

// -----------------------------------------------------------------

#define MB_QUESTION_OK \
        MB_EXTRA (ICONQUESTION, OK)

#define MB_QUESTION_OKCANCEL \
        MB_EXTRA (ICONQUESTION, OKCANCEL)

#define MB_QUESTION_ABORTRETRYIGNORE \
        MB_EXTRA (ICONQUESTION, ABORTRETRYIGNORE)

#define MB_QUESTION_YESNOCANCEL \
        MB_EXTRA (ICONQUESTION, YESNOCANCEL)

#define MB_QUESTION_YESNO \
        MB_EXTRA (ICONQUESTION, YESNO)

#define MB_QUESTION_RETRYCANCEL \
        MB_EXTRA (ICONQUESTION, RETRYCANCEL)

#define MB_QUESTION_CANCELTRYCONTINUE \
        MB_EXTRA (ICONQUESTION, CANCELTRYCONTINUE)

// -----------------------------------------------------------------

#define MB_WARNING_OK \
        MB_EXTRA (ICONWARNING, OK)

#define MB_WARNING_OKCANCEL \
        MB_EXTRA (ICONWARNING, OKCANCEL)

#define MB_WARNING_ABORTRETRYIGNORE \
        MB_EXTRA (ICONWARNING, ABORTRETRYIGNORE)

#define MB_WARNING_YESNOCANCEL \
        MB_EXTRA (ICONWARNING, YESNOCANCEL)

#define MB_WARNING_YESNO \
        MB_EXTRA (ICONWARNING, YESNO)

#define MB_WARNING_RETRYCANCEL \
        MB_EXTRA (ICONWARNING, RETRYCANCEL)

#define MB_WARNING_CANCELTRYCONTINUE \
        MB_EXTRA (ICONWARNING, CANCELTRYCONTINUE)

// -----------------------------------------------------------------

#define MB_INFORMATION_OK \
        MB_EXTRA (ICONINFORMATION, OK)

#define MB_INFORMATION_OKCANCEL \
        MB_EXTRA (ICONINFORMATION, OKCANCEL)

#define MB_INFORMATION_ABORTRETRYIGNORE \
        MB_EXTRA (ICONINFORMATION, ABORTRETRYIGNORE)

#define MB_INFORMATION_YESNOCANCEL \
        MB_EXTRA (ICONINFORMATION, YESNOCANCEL)

#define MB_INFORMATION_YESNO \
        MB_EXTRA (ICONINFORMATION, YESNO)

#define MB_INFORMATION_RETRYCANCEL \
        MB_EXTRA (ICONINFORMATION, RETRYCANCEL)

#define MB_INFORMATION_CANCELTRYCONTINUE \
        MB_EXTRA (ICONINFORMATION, CANCELTRYCONTINUE)

// -----------------------------------------------------------------

#define MB_USER_OK \
        MB_EXTRA (USERICON, OK)

#define MB_USER_OKCANCEL \
        MB_EXTRA (USERICON, OKCANCEL)

#define MB_USER_ABORTRETRYIGNORE \
        MB_EXTRA (USERICON, ABORTRETRYIGNORE)

#define MB_USER_YESNOCANCEL \
        MB_EXTRA (USERICON, YESNOCANCEL)

#define MB_USER_YESNO \
        MB_EXTRA (USERICON, YESNO)

#define MB_USER_RETRYCANCEL \
        MB_EXTRA (USERICON, RETRYCANCEL)

#define MB_USER_CANCELTRYCONTINUE \
        MB_EXTRA (USERICON, CANCELTRYCONTINUE)

// =================================================================
// CONSOLE COLOR ATTRIBUTES
// =================================================================

#define FOREGROUND_BLACK   0
#define FOREGROUND_CYAN    (FOREGROUND_GREEN | FOREGROUND_BLUE     )
#define FOREGROUND_MAGENTA (FOREGROUND_RED   | FOREGROUND_BLUE     )
#define FOREGROUND_YELLOW  (FOREGROUND_RED   | FOREGROUND_GREEN    )
#define FOREGROUND_GRAY    (FOREGROUND_RED   | FOREGROUND_CYAN     )
#define FOREGROUND_WHITE   (FOREGROUND_GRAY  | FOREGROUND_INTENSITY)

#define BACKGROUND_BLACK   0
#define BACKGROUND_CYAN    (BACKGROUND_GREEN | BACKGROUND_BLUE     )
#define BACKGROUND_MAGENTA (BACKGROUND_RED   | BACKGROUND_BLUE     )
#define BACKGROUND_YELLOW  (BACKGROUND_RED   | BACKGROUND_GREEN    )
#define BACKGROUND_GRAY    (BACKGROUND_RED   | BACKGROUND_CYAN     )
#define BACKGROUND_WHITE   (BACKGROUND_GRAY  | BACKGROUND_INTENSITY)

// =================================================================
// CONSTANTS
// =================================================================

#define SBS_UNSIGNED8               ( 3 + 1)
#define SBS_UNSIGNED16              ( 5 + 1)
#define SBS_UNSIGNED32              (10 + 1)

#define SBS_SIGNED8                 (1 + SBS_UNSIGNED8 )
#define SBS_SIGNED16                (1 + SBS_UNSIGNED16)
#define SBS_SIGNED32                (1 + SBS_UNSIGNED32)

#define SBS_STRING                  0x00000100
#define SBS_PAGE                    0x00001000
#define SBS_BLOCK                   0x00001000
#define SBS_SELECT                  0x0000FFFF
#define SBS_KEY                     (MAX_PATH + 1)

#define SBS_ATOM_FIRST              ((ATOM) MAXINTATOM)
#define SBS_ATOM_LAST               ((ATOM) -1        )
#define SBS_ATOM_STRING             256

// -----------------------------------------------------------------

#define SBS_FONT_DEFAULT            0
#define SBS_FONT_LARGE              1
#define SBS_FONT_SMALL              2
#define SBS_FONT_LIGHT              3

// -----------------------------------------------------------------

#define SBS_BRUSH_EDIT              WHITE_BRUSH
#define SBS_BRUSH_LIST              WHITE_BRUSH
#define SBS_BRUSH_BUTTON            LTGRAY_BRUSH
#define SBS_BRUSH_DEFAULT           LTGRAY_BRUSH

// -----------------------------------------------------------------

#define SBS_DEFAULT_BACKGROUND      SBS_COLOR_LTGRAY
#define SBS_DEFAULT_FOREGROUND      SBS_COLOR_BLACK

#define SBS_COLOR_BLACK             RGB (  0,   0,   0)
#define SBS_COLOR_DKGRAY            RGB (128, 128, 128)
#define SBS_COLOR_LTGRAY            RGB (192, 192, 192)
#define SBS_COLOR_WHITE             RGB (255, 255, 255)

#define SBS_COLOR_BACKGROUND(_pcr) \
        SAFEVAL (_pcr, SBS_DEFAULT_BACKGROUND)

#define SBS_COLOR_FOREGROUND(_pcr) \
        SAFEVAL (_pcr, SBS_DEFAULT_FOREGROUND)

// -----------------------------------------------------------------

#define SBS_DEFAULT_HANDLER         (MAXDWORD-1)
#define SBS_DEFAULT_RESULT          (MAXDWORD-2)

#define SBS_DEFAULT_WINDOW_WIDTH    500
#define SBS_DEFAULT_WINDOW_HEIGHT   300

#define SBS_DEFAULT_DESKTOP_WIDTH   640
#define SBS_DEFAULT_DESKTOP_HEIGHT  480

#define SBS_DEFAULT_INFO_WIDTH      (2 + 400 + 2)
#define SBS_DEFAULT_INFO_HEIGHT     (2 +  96 + 2)

// -----------------------------------------------------------------

#define SBS_STYLE_FRAME             0x00000001
#define SBS_STYLE_FLAT              0x00000002
#define SBS_STYLE_POP_OUT           0x00000004
#define SBS_STYLE_PREFIX            0x00000008
#define SBS_STYLE_LEFT              0x00000010
#define SBS_STYLE_RIGHT             0x00000020
#define SBS_STYLE_TOP               0x00000040
#define SBS_STYLE_BOTTOM            0x00000080

#define SBS_STYLE_FLAGS             0x000000FF
#define SBS_STYLE_MARGINS           0xFFFFFF00

#define SBS_STYLE_MARGIN_MASK       0xFC
#define SBS_STYLE_MARGIN_ROUND      0x02

#define SBS_STYLE_MARGIN(_m)                                  \
        ((_m) >= SBS_STYLE_MARGIN_MASK                        \
         ? SBS_STYLE_MARGIN_MASK                              \
         : (((_m) + (((_m) & SBS_STYLE_MARGIN_ROUND) << 1)) & \
            SBS_STYLE_MARGIN_MASK))

#define SBS_STYLE_MARGIN_LEFT_       6
#define SBS_STYLE_MARGIN_RIGHT_     12
#define SBS_STYLE_MARGIN_TOP_       18
#define SBS_STYLE_MARGIN_BOTTOM_    24

#define SBS_STYLE_MARGIN_VALUE(_s,_n) \
        (((_s) >> (_n)) & SBS_STYLE_MARGIN_MASK)

#define SBS_STYLE_MARGIN_LEFT(_s) \
        SBS_STYLE_MARGIN_VALUE (_s, SBS_STYLE_MARGIN_LEFT_  )

#define SBS_STYLE_MARGIN_RIGHT(_s) \
        SBS_STYLE_MARGIN_VALUE (_s, SBS_STYLE_MARGIN_RIGHT_ )

#define SBS_STYLE_MARGIN_TOP(_s) \
        SBS_STYLE_MARGIN_VALUE (_s, SBS_STYLE_MARGIN_TOP_   )

#define SBS_STYLE_MARGIN_BOTTOM(_s) \
        SBS_STYLE_MARGIN_VALUE (_s, SBS_STYLE_MARGIN_BOTTOM_)

#define SBS_STYLE(_f,_l,_r,_t,_b)                              \
        ((                 (_f)  & SBS_STYLE_FLAGS         ) | \
         (SBS_STYLE_MARGIN (_l) << SBS_STYLE_MARGIN_LEFT_  ) | \
         (SBS_STYLE_MARGIN (_r) << SBS_STYLE_MARGIN_RIGHT_ ) | \
         (SBS_STYLE_MARGIN (_t) << SBS_STYLE_MARGIN_TOP_   ) | \
         (SBS_STYLE_MARGIN (_b) << SBS_STYLE_MARGIN_BOTTOM_))

// -----------------------------------------------------------------

#define SBS_MODE_DWORD              0xFFFFFFFF
#define SBS_MODE_TEXT               0xFFFFFFFE
#define SBS_MODE_BINARY(_m)         ((DWORD) (_m) < SBS_MODE_TEXT)

// -----------------------------------------------------------------

#define SBS_INI_STRING              (-1)
#define SBS_INI_DWORD               (-2)
#define SBS_INI_LONG                (-3)
#define SBS_INI_BOOL                (-4)
#define SBS_INI_COLOR               (-5)
#define SBS_INI_FONT                (-6)

// -----------------------------------------------------------------

#define SBS_COMMAND_STARTUP          0
#define SBS_COMMAND_CLEANUP          1
#define SBS_COMMAND_TIMER            2
#define SBS_COMMAND_COPYDATA         3
#define SBS_COMMAND_MESSAGE          4
#define SBS_COMMAND_UPDATE           5
#define SBS_COMMAND_RESERVED6        6
#define SBS_COMMAND_RESERVED7        7
#define SBS_COMMAND_RESERVED8        8
#define SBS_COMMAND_RESERVED9        9
#define SBS_COMMAND_USER            10

// -----------------------------------------------------------------

#define BOOL_                       sizeof (BOOL)
#define BOOLEAN_                    sizeof (BOOLEAN)
#define BYTE_                       sizeof (BYTE)
#define CHAR_                       sizeof (CHAR)
#define DOUBLE_                     sizeof (DOUBLE)
#define DWORD_                      sizeof (DWORD)
#define DWORDLONG_                  sizeof (DWORDLONG)
#define FLOAT_                      sizeof (FLOAT)
#define INT_                        sizeof (INT)
#define INT8_                       sizeof (__int8)
#define INT16_                      sizeof (__int16)
#define INT32_                      sizeof (__int32)
#define INT64_                      sizeof (__int64)
#define LONG_                       sizeof (LONG)
#define LONGLONG_                   sizeof (LONGLONG)
#define PVOID_                      sizeof (PVOID)
#define QWORD_                      sizeof (QWORD)
#define SHORT_                      sizeof (SHORT)
#define TBYTE_                      sizeof (TBYTE)
#define UCHAR_                      sizeof (UCHAR)
#define UINT_                       sizeof (UINT)
#define ULONG_                      sizeof (ULONG)
#define USHORT_                     sizeof (USHORT)
#define WORD_                       sizeof (WORD)

#define BYTE__                      (BYTE_  * 8)
#define WORD__                      (WORD_  * 8)
#define DWORD__                     (DWORD_ * 8)
#define QWORD__                     (QWORD_ * 8)

// -----------------------------------------------------------------

#define BITMAPFILEHEADER_           sizeof (BITMAPFILEHEADER)
#define BITMAPINFO_                 sizeof (BITMAPINFO)
#define BITMAPINFOHEADER_           sizeof (BITMAPINFOHEADER)
#define CHOOSECOLORA_               sizeof (CHOOSECOLORA)
#define CHOOSECOLORW_               sizeof (CHOOSECOLORW)
#define CHOOSEFONTA_                sizeof (CHOOSEFONTA)
#define CHOOSEFONTW_                sizeof (CHOOSEFONTW)
#define CLSID_                      sizeof (CLSID)
#define COLORREF_                   sizeof (COLORREF)
#define CONTROLINFO_                sizeof (CONTROLINFO)
#define COPYDATASTRUCT_             sizeof (COPYDATASTRUCT)
#define CRITICAL_SECTION_           sizeof (CRITICAL_SECTION)
#define DVTARGETDEVICE_             sizeof (DVTARGETDEVICE)
#define FMTID_                      sizeof (FMTID)
#define GUID_                       sizeof (GUID)
#define IID_                        sizeof (IID)
#define LOGFONTA_                   sizeof (LOGFONTA)
#define LOGFONTW_                   sizeof (LOGFONTW)
#define LOGPALETTE_                 sizeof (LOGPALETTE)
#define NOTIFYICONDATAA_            sizeof (NOTIFYICONDATAA)
#define NOTIFYICONDATAW_            sizeof (NOTIFYICONDATAW)
#define PALETTEENTRY_               sizeof (PALETTEENTRY)
#define RECT_                       sizeof (RECT)
#define RGBQUAD_                    sizeof (RGBQUAD)
#define UUID_                       sizeof (UUID)
#define WINDOWPLACEMENT_            sizeof (WINDOWPLACEMENT)

// -----------------------------------------------------------------

#ifdef  UNICODE

#define CHOOSECOLOR_                CHOOSECOLORW_
#define CHOOSEFONT_                 CHOOSEFONTW_
#define LOGFONT_                    LOGFONTW_
#define NOTIFYICONDATA_             NOTIFYICONDATAW_

#else   // #ifdef UNICODE

#define CHOOSECOLOR_                CHOOSECOLORA_
#define CHOOSEFONT_                 CHOOSEFONTA_
#define LOGFONT_                    LOGFONTA_
#define NOTIFYICONDATA_             NOTIFYICONDATAA_

#endif  // #ifdef UNICODE

// -----------------------------------------------------------------

#define BITMAP_OFFSET_INFO  BITMAPFILEHEADER_
#define BITMAP_OFFSET_RGB   (BITMAP_OFFSET_INFO + BITMAPINFOHEADER_)

// -----------------------------------------------------------------

#define HKEY_NULL                   ((HKEY ) -1)
#define VERSION_NULL                ((QWORD) -1)
#define MAGIC_BMP                   'MB'
#define VERSION_PALETTE             0x0300
#define ICON_PIXELS                 32

// -----------------------------------------------------------------

#define YEARS_1600_TO_1970 ((DWORD) (1970-1600))
#define YEARS_400          ((DWORD) 400)
#define YEARS_100          ((DWORD) 100)
#define YEARS_004          ((DWORD) 4)

#define DAYS_1600_TO_1970  ((YEARS_1600_TO_1970 * 365) +25+24+24+17)
#define DAYS_PER_400_YEARS ((YEARS_400          * 365) +25+24+24+24)
#define DAYS_PER_100_YEARS ((YEARS_100          * 365) +25)
#define DAYS_PER_4_YEARS   ((YEARS_004          * 365) + 1)
#define DAYS_PER_YEAR      ((DWORD)               365)

// -----------------------------------------------------------------

#ifndef OPENFILENAME_SIZE_VERSION_400A
#define OPENFILENAME_SIZE_VERSION_400A sizeof (OPENFILENAMEA)
#endif

#ifndef OPENFILENAME_SIZE_VERSION_400W
#define OPENFILENAME_SIZE_VERSION_400W sizeof (OPENFILENAMEW)
#endif

// =================================================================
// POINTER TYPES
// =================================================================

typedef const CLSID         CCLSID;
typedef const FMTID         CFMTID;
typedef const GUID          CGUID;
typedef const IID           CIID;
typedef const OLECHAR       COLECHAR;
typedef const UUID          CUUID;

typedef CCLSID              *PCCLSID,           **PPCCLSID;
typedef CFMTID              *PCFMTID,           **PPCFMTID;
typedef CGUID               *PCGUID,            **PPCGUID;
typedef CIID                *PCIID,             **PPCIID;
typedef CLSID               *PCLSID,            **PPCLSID;
typedef COLECHAR            *PCOLESTR,          **PPCOLESTR;
typedef COLORREF            *PCOLORREF,         **PPCOLORREF;
typedef CONTROLINFO         *PCONTROLINFO,      **PPCONTROLINFO;
typedef CUUID               *PCUUID,            **PPCUUID;
typedef DVTARGETDEVICE      *PDVTARGETDEVICE,   **PPDVTARGETDEVICE;
typedef FMTID               *PFMTID,            **PPFMTID;
typedef GUID                *PGUID,             **PPGUID;
typedef HBITMAP             *PHBITMAP,          **PPHBITMAP;
typedef HICON               *PHICON,            **PPHICON;
typedef HMODULE             *PHMODULE,          **PPHMODULE;
typedef HWND                *PHWND,             **PPHWND;
typedef IID                 *PIID,              **PPIID;
typedef OLECHAR             *POLESTR,           **PPOLESTR;
typedef RGBQUAD             *PRGBQUAD,          **PPRGBQUAD;
typedef UUID                *PUUID,             **PPUUID;

typedef REFCLSID            *PREFCLSID;
typedef REFFMTID            *PREFFMTID;
typedef REFGUID             *PREFGUID;
typedef REFIID              *PREFIID;

typedef VOID                                    **PPVOID;
typedef BYTE                                    **PPBYTE;
typedef TBYTE                                   **PPTBYTE;
typedef WORD                                    **PPWORD;
typedef DWORD                                   **PPDWORD;
typedef DWORDLONG   QWORD,  *PQWORD,            **PPQWORD;

// =================================================================
// URL CACHE DEFINITIONS
// =================================================================

#define INTERNET_CACHE_ENTRY_INFOA_ \
        sizeof (INTERNET_CACHE_ENTRY_INFOA)

#define INTERNET_CACHE_ENTRY_INFOW_ \
        sizeof (INTERNET_CACHE_ENTRY_INFOW)

// -----------------------------------------------------------------

typedef INTERNET_CACHE_ENTRY_INFOA   *PINTERNET_CACHE_ENTRY_INFOA,
                                   **PPINTERNET_CACHE_ENTRY_INFOA;

typedef INTERNET_CACHE_ENTRY_INFOW   *PINTERNET_CACHE_ENTRY_INFOW,
                                   **PPINTERNET_CACHE_ENTRY_INFOW;

// -----------------------------------------------------------------

#ifdef  UNICODE

#define   INTERNET_CACHE_ENTRY_INFO_   INTERNET_CACHE_ENTRY_INFOW_
#define  PINTERNET_CACHE_ENTRY_INFO   PINTERNET_CACHE_ENTRY_INFOW
#define PPINTERNET_CACHE_ENTRY_INFO  PPINTERNET_CACHE_ENTRY_INFOW

#else   // #ifdef UNICODE

#define   INTERNET_CACHE_ENTRY_INFO_   INTERNET_CACHE_ENTRY_INFOA_
#define  PINTERNET_CACHE_ENTRY_INFO   PINTERNET_CACHE_ENTRY_INFOA
#define PPINTERNET_CACHE_ENTRY_INFO  PPINTERNET_CACHE_ENTRY_INFOA

#endif  // #ifdef UNICODE

// =================================================================
// FUNCTION TYPES
// =================================================================

typedef LRESULT
        (WINAPI *SBS_HANDLER) (struct _SBS_THREAD *pst,
                               DWORD               dCommand,
                               PVOID               pCommand);

typedef LRESULT
        (WINAPI *SBS_SPY)     (struct _SBS_THREAD *pst,
                               PVOID               pContext);

// -----------------------------------------------------------------

#define SBS_LIST_STATUS0   0 // user-defined status code 0
#define SBS_LIST_STATUS1   1 // user-defined status code 1
#define SBS_LIST_STATUS2   2 // user-defined status code 2
#define SBS_LIST_STATUS3   3 // user-defined status code 3
#define SBS_LIST_STATUS4   4 // user-defined status code 4
#define SBS_LIST_STATUS5   5 // user-defined status code 5
#define SBS_LIST_STATUS6   6 // user-defined status code 6
#define SBS_LIST_STATUS7   7 // user-defined status code 7
#define SBS_LIST_STATUS8   8 // user-defined status code 8
#define SBS_LIST_STATUS9   9 // user-defined status code 9
#define SBS_LIST_ERROR    10 // abnormal end
#define SBS_LIST_OK       11 // normal end
#define SBS_LIST_CONTINUE 12 // non-terminating status codes

#define SBS_LIST_ADD      (SBS_LIST_CONTINUE + 0) // add item
#define SBS_LIST_IGNORE   (SBS_LIST_CONTINUE + 1) // don't add item

typedef DWORD (WINAPI *SBS_LISTNEW)  (struct _SBS_LIST *psl,
                                      DWORD             dId,
                                      PVOID             pContext,
                                      PPVOID            ppText,
                                      PDWORD            pdData);

// =================================================================
// ENUMERATIONS
// =================================================================

typedef enum _SBS_LIST_MESSAGE
    {
    SBS_ADDFILE,
    SBS_ADDSTRING,
    SBS_DELETESTRING,
    SBS_DIR,
    SBS_FINDSTRING,
    SBS_FINDSTRINGEXACT,
    SBS_GETCOUNT,
    SBS_GETCURSEL,
    SBS_GETDROPPEDSTATE,
    SBS_GETEDITSEL,
    SBS_GETITEMDATA,
    SBS_GETSEL,
    SBS_GETSELCOUNT,
    SBS_GETSELITEMS,
    SBS_GETTEXT,
    SBS_GETTEXTLEN,
    SBS_GETTOPINDEX,
    SBS_INITSTORAGE,
    SBS_INSERTSTRING,
    SBS_ITEMFROMPOINT,
    SBS_LIMITTEXT,
    SBS_RESETCONTENT,
    SBS_SELECTSTRING,
    SBS_SETCOLUMNWIDTH,
    SBS_SETCURSEL,
    SBS_SETEDITSEL,
    SBS_SETITEMDATA,
    SBS_SETREDRAW,
    SBS_SETSEL,
    SBS_SETTABSTOPS,
    SBS_SETTOPINDEX,
    SBS_SHOWDROPDOWN,
    SBS_LIST_MESSAGE_
    }
    SBS_LIST_MESSAGE, *PSBS_LIST_MESSAGE, **PPSBS_LIST_MESSAGE;

// -----------------------------------------------------------------

typedef enum _SBS_LIST_NOTIFY
    {
    SBS_CLOSEUP,
    SBS_DBLCLK,
    SBS_SELCHANGE,
    SBS_LIST_NOTIFY_
    }
    SBS_LIST_NOTIFY, *PSBS_LIST_NOTIFY, **PPSBS_LIST_NOTIFY;

// =================================================================
// STRUCTURES
// =================================================================

typedef struct _SBS_VERSION
    {
    DWORD dRequired;
    DWORD dInstalled;
    union
        {
        PTBYTE ptFilename;
        PBYTE  pbFilename;
        PWORD  pwFilename;
        };
    }
    SBS_VERSION, *PSBS_VERSION, **PPSBS_VERSION;

#define SBS_VERSION_ sizeof (SBS_VERSION)

// -----------------------------------------------------------------

typedef struct _SBS_BUFFER
    {
    DWORD dOffset;
    DWORD dData;
    DWORD dBlock;
    union
        {
        PTBYTE ptData;
        PBYTE  pbData;
        PWORD  pwData;
        PVOID  pData;
        };
    }
    SBS_BUFFER, *PSBS_BUFFER, **PPSBS_BUFFER;

#define SBS_BUFFER_ sizeof (SBS_BUFFER)

// -----------------------------------------------------------------

typedef struct _SBS_VALUE
    {
    union
        {
        PTBYTE ptValue;
        PBYTE  pbValue;
        PWORD  pwValue;
        };
    DWORD dMode;
    union
        {
        PTBYTE ptData;
        PBYTE  pbData;
        PWORD  pwData;
        DWORD  dData;
        PVOID  pData;
        };
    }
    SBS_VALUE, *PSBS_VALUE, **PPSBS_VALUE;

#define SBS_VALUE_ sizeof (SBS_VALUE)

// -----------------------------------------------------------------

typedef struct _SBS_PATH
    {
    BOOL fUnicode;
    HKEY hk;
    HKEY hkBase;
    union
        {
        PTBYTE ptParts;
        PBYTE  pbParts;
        PWORD  pwParts;
        PVOID  pParts;
        };
    union
        {
        PTBYTE ptRoot;
        PBYTE  pbRoot;
        PWORD  pwRoot;
        };
    union
        {
        PTBYTE ptKey;
        PBYTE  pbKey;
        PWORD  pwKey;
        };
    union
        {
        PTBYTE ptValue;
        PBYTE  pbValue;
        PWORD  pwValue;
        };
    }
    SBS_PATH, *PSBS_PATH, **PPSBS_PATH;

#define SBS_PATH_ sizeof (SBS_PATH)

// -----------------------------------------------------------------

typedef struct _SBS_LOCK
    {
    BOOL fLocked;
    }
    SBS_LOCK, *PSBS_LOCK, **PPSBS_LOCK;

#define SBS_LOCK_ sizeof (SBS_LOCK)

// -----------------------------------------------------------------

typedef struct _SBS_INFO
    {
    BOOL     fUnicode;
    HICON    hIcon;
    HBITMAP  hBitmap;
    COLORREF crText;
    COLORREF crArea;
    union
        {
        TBYTE atInfo [SBS_STRING];
        BYTE  abInfo [SBS_STRING];
        WORD  awInfo [SBS_STRING];
        };
    }
    SBS_INFO, *PSBS_INFO, **PPSBS_INFO;

#define SBS_INFO_ sizeof (SBS_INFO)

// -----------------------------------------------------------------

typedef struct _SBS_PAD
    {
    PVOID pData;
    DWORD dData;
    BOOL  fData;
    }
    SBS_PAD, *PSBS_PAD, **PPSBS_PAD;

#define SBS_PAD_ sizeof (SBS_PAD)

// -----------------------------------------------------------------

typedef struct _SBS_THREAD
    {
    SBS_LOCK    Lock;
    SBS_INFO    Info;
    SBS_PAD     Pad;
    DWORD       dWidth;
    DWORD       dHeight;
    DWORD       dTime;
    DWORD       dTimer;
    SBS_HANDLER Handler;
    PVOID       pContext;
    DWORD       dOwner;
    HWND        hOwner;
    HWND        hWnd;
    HANDLE      hEvent;
    HANDLE      hThread;
    DWORD       dThread;
    DWORD       dSeconds;
    FILETIME    ftStart;
    FILETIME    ftNow;
    }
    SBS_THREAD, *PSBS_THREAD, **PPSBS_THREAD;

#define SBS_THREAD_ sizeof (SBS_THREAD)

// -----------------------------------------------------------------

typedef struct _SBS_MESSAGE
    {
    HWND        hWnd;
    UINT        uiMsg;
    WPARAM      wParam;
    LPARAM      lParam;
    PSBS_THREAD pst;
    }
    SBS_MESSAGE, *PSBS_MESSAGE, **PPSBS_MESSAGE;

#define SBS_MESSAGE_ sizeof (SBS_MESSAGE)

// -----------------------------------------------------------------

typedef struct _SBS_WINDOW
    {
    BOOL     fUnicode;
    PVOID    pContext;
    HWND     hWndParent;
    HWND     hWnd;
    HWND     hStatus;
    HFONT    hFont;
    HBRUSH   hBrush;
    COLORREF crColor;
    COLORREF crBrush;
    DWORD    dMode;
    DWORD    dColumn;
    DWORD    dRow;
    DWORD    dWidth;
    DWORD    dHeight;
    union
        {
        LOGFONT  lf;
        LOGFONTA lfA;
        LOGFONTW lfW;
        };
    union
        {
        WNDCLASS  wc;
        WNDCLASSA wcA;
        WNDCLASSW wcW;
        };
    union
        {
        TBYTE  atProfile [MAX_PATH];
        BYTE   abProfile [MAX_PATH];
        WORD   awProfile [MAX_PATH];
        };
    union
        {
        TBYTE  atWindow  [SBS_STRING];
        BYTE   abWindow  [SBS_STRING];
        WORD   awWindow  [SBS_STRING];
        };
    union
        {
        TBYTE  atCaption [SBS_STRING];
        BYTE   abCaption [SBS_STRING];
        WORD   awCaption [SBS_STRING];
        };
    union
        {
        TBYTE  atClass   [SBS_STRING];
        BYTE   abClass   [SBS_STRING];
        WORD   awClass   [SBS_STRING];
        };
    union
        {
        TBYTE  atMenu    [SBS_STRING];
        BYTE   abMenu    [SBS_STRING];
        WORD   awMenu    [SBS_STRING];
        };
    }
    SBS_WINDOW, *PSBS_WINDOW, **PPSBS_WINDOW;

#define SBS_WINDOW_ sizeof (SBS_WINDOW)

// -----------------------------------------------------------------

typedef struct _SBS_DIALOG_ARG
    {
    INT iItem;
    INT iFont;
    }
    SBS_DIALOG_ARG, *PSBS_DIALOG_ARG, **PPSBS_DIALOG_ARG;

#define SBS_DIALOG_ARG_ sizeof (SBS_DIALOG_ARG)

// -----------------------------------------------------------------

typedef struct _SBS_DIALOG_ITEM
    {
    INT  iItem;
    INT  iFont;
    RECT rNormal;
    RECT rCurrent;
    }
    SBS_DIALOG_ITEM, *PSBS_DIALOG_ITEM, **PPSBS_DIALOG_ITEM;

#define SBS_DIALOG_ITEM_ sizeof (SBS_DIALOG_ITEM)

// -----------------------------------------------------------------

#define SBS_DIALOG_FONTS 4

typedef struct _SBS_DIALOG
    {
    HWND            hWnd;
    HFONT           ahfNormal  [SBS_DIALOG_FONTS];
    HFONT           ahfCurrent [SBS_DIALOG_FONTS];
    RECT            rNormal;
    RECT            rCurrent;
    DWORD           dItems;
    SBS_DIALOG_ITEM aItems [];
    }
    SBS_DIALOG, *PSBS_DIALOG, **PPSBS_DIALOG;

#define SBS_DIALOG_ OFFSET (SBS_DIALOG, aItems)
#define SBS_DIALOG__(_n) (SBS_DIALOG_ + ((_n) * SBS_DIALOG_ITEM_))

// -----------------------------------------------------------------

typedef struct _SBS_SHADES
    {
    COLORREF crBlack;
    COLORREF crDark;
    COLORREF crNormal;
    COLORREF crLight;
    COLORREF crWhite;
    }
    SBS_SHADES, *PSBS_SHADES, **PPSBS_SHADES;

#define SBS_SHADES_ sizeof (SBS_SHADES)

// -----------------------------------------------------------------

typedef struct _SBS_BITMAP
    {
    DWORD            dRows;
    DWORD            dColumns;
    DWORD            dColors;
    DWORD            dPalette;
    DWORD            dBitsPerPixel;
    DWORD            dBytesPerPixel;
    DWORD            dPixelsPerByte;
    DWORD            dTotal;
    DWORD            dBitmap;
    PVOID            pBitmap;
    PBITMAPINFO      pbi;
    HPALETTE         hPalette;
    WORD             wReserved;
    BITMAPFILEHEADER bfh;
    BITMAPINFOHEADER bih;
    RGBQUAD          Palette [];
    }
    SBS_BITMAP, *PSBS_BITMAP, **PPSBS_BITMAP;

#define SBS_BITMAP_       OFFSET (SBS_BITMAP, Palette)
#define SBS_BITMAP_OFFSET OFFSET (SBS_BITMAP, bfh    )
#define SBS_BITMAP_HEADER (SBS_BITMAP_ - SBS_BITMAP_OFFSET)

// -----------------------------------------------------------------

typedef struct _SBS_COOKIE_VALUE
    {
    union
        {
        PTBYTE ptKey;
        PBYTE  pbKey;
        PWORD  pwKey;
        };
    union
        {
        PTBYTE ptValue;
        PBYTE  pbValue;
        PWORD  pwValue;
        };
    union
        {
        PTBYTE ptDomain;
        PBYTE  pbDomain;
        PWORD  pwDomain;
        };
    DWORD    dKey;
    DWORD    dValue;
    DWORD    dDomain;
    BOOL     fSecure;
    FILETIME ftExpire;
    FILETIME ftWrite;
    }
    SBS_COOKIE_VALUE, *PSBS_COOKIE_VALUE, **PPSBS_COOKIE_VALUE;

#define SBS_COOKIE_VALUE_ sizeof (SBS_COOKIE_VALUE)

// -----------------------------------------------------------------

typedef struct _SBS_COOKIE
    {
    FILETIME ftCreate;
    FILETIME ftAccess;
    FILETIME ftWrite;
    union
        {
        PTBYTE ptData;
        PBYTE  pbData;
        PWORD  pwData;
        PVOID  pData;
        };
    DWORD            dData;
    DWORD            dValues;
    SBS_COOKIE_VALUE aValues [];
    }
    SBS_COOKIE, *PSBS_COOKIE, **PPSBS_COOKIE;

#define SBS_COOKIE_ OFFSET (SBS_COOKIE, aValues)
#define SBS_COOKIE__(_n) (SBS_COOKIE_ + ((_n) * SBS_COOKIE_VALUE_))

// -----------------------------------------------------------------

#define SBS_URL_BUFFER 0x00010000

typedef struct _SBS_URL
    {
    BOOL     fUnicode;
    DWORD    dBuffer;
    HANDLE   hInfo;
    FILETIME ftExpire;
    FILETIME ftWrite;
    union
        {
        PTBYTE ptName;
        PBYTE  pbName;
        PWORD  pwName;
        };
    union
        {
        PTBYTE ptPath;
        PBYTE  pbPath;
        PWORD  pwPath;
        };
    union
        {
        PTBYTE ptFile;
        PBYTE  pbFile;
        PWORD  pwFile;
        };
    union
        {
        INTERNET_CACHE_ENTRY_INFO  Info;
        INTERNET_CACHE_ENTRY_INFOA InfoA;
        INTERNET_CACHE_ENTRY_INFOW InfoW;
        BYTE                       abBuffer [SBS_URL_BUFFER];
        };
    }
    SBS_URL, *PSBS_URL, **PPSBS_URL;

#define SBS_URL_ sizeof (SBS_URL)
#define SBS_URL__(_n) (SBS_URL_ - SBS_URL_BUFFER + (_n))

// -----------------------------------------------------------------

typedef struct _SBS_TIME
    {
    WORD wYear;
    BYTE bMonth;
    BYTE bDay;
    BYTE bHour;
    BYTE bMinute;
    BYTE bSecond;
    BYTE bDayOfWeek;
    }
    SBS_TIME, *PSBS_TIME, **PPSBS_TIME;

#define SBS_TIME_ sizeof (SBS_TIME)

// -----------------------------------------------------------------

#define SBS_LIST_END (-2)

typedef struct _SBS_LIST
    {
    BOOL    fUnicode;
    BOOL    fOk;
    DWORD   dStatus;
    DWORD   dCount;
    INT     iItem;
    HWND    hItem;
    HWND    hWnd;
    HCURSOR hcWait;
    HCURSOR hcDefault;
    BOOL    fCombo;
    DWORD   dError;
    DWORD   dErrorSpace;
    UINT    auiMsg [SBS_LIST_MESSAGE_];
    DWORD   adCode [SBS_LIST_NOTIFY_ ];
    }
    SBS_LIST, *PSBS_LIST, **PPSBS_LIST;

#define SBS_LIST_ sizeof (SBS_LIST)

// -----------------------------------------------------------------

typedef struct _SBS_PARAMETER
    {
    union
        {
        PTBYTE ptKey;
        PBYTE  pbKey;
        PWORD  pwKey;
        };
    PVOID pData;
    DWORD dType;
    }
    SBS_PARAMETER, *PSBS_PARAMETER, **PPSBS_PARAMETER;

#define SBS_PARAMETER_ sizeof (SBS_PARAMETER)

// -----------------------------------------------------------------

typedef struct _SBS_TEXT
    {
    PBYTE pbData;
    PWORD pwData;
    }
    SBS_TEXT, *PSBS_TEXT, **PPSBS_TEXT;

#define SBS_TEXT_ sizeof (SBS_TEXT)

#define SBS_TEXTA(_p) ((_p)->pbData)
#define SBS_TEXTW(_p) ((_p)->pwData)

// -----------------------------------------------------------------

typedef struct _SBS_COLUMN
    {
    INT       iItem;
    DWORD     dOffset;
    DWORD     dWidth;
    DWORD     dFormat;
    BOOL      fSeparator;
    PSBS_TEXT pst;
    }
    SBS_COLUMN, *PSBS_COLUMN, **PPSBS_COLUMN;

#define SBS_COLUMN_ sizeof (SBS_COLUMN)

// -----------------------------------------------------------------

#define SBS_BSTR_BLOCK 16

typedef struct _SBS_BSTR
    {
    DWORD dBytes;    // number of bytes, terminator not counted
    WORD  awData []; // zero-terminated Unicode string
    }
    SBS_BSTR, *PSBS_BSTR, **PPSBS_BSTR;

#define SBS_BSTR_      OFFSET (SBS_BSTR, awData)
#define SBS_BSTR__(_n) (SBS_BSTR_ + ((_n) * WORD_))

#define SBS_BSTR_BASE(_p) BASE((_p), SBS_BSTR, awData)

// -----------------------------------------------------------------

typedef struct _SBS_ABOUT
    {
    BOOL fUnicode;
    union
        {
        PTBYTE ptCaption;
        PBYTE  pbCaption;
        PWORD  pwCaption;
        };
    union
        {
        PTBYTE ptText1;
        PBYTE  pbText1;
        PWORD  pwText1;
        };
    union
        {
        PTBYTE ptText2;
        PBYTE  pbText2;
        PWORD  pwText2;
        };
    union
        {
        PTBYTE ptText3;
        PBYTE  pbText3;
        PWORD  pwText3;
        };
    union
        {
        PTBYTE ptText4;
        PBYTE  pbText4;
        PWORD  pwText4;
        };
    WNDPROC IconProc1;
    WNDPROC IconProc2;
    HICON   hIcon1;
    HICON   hIcon2;
    HWND    hWnd;
    }
    SBS_ABOUT, *PSBS_ABOUT, **PPSBS_ABOUT;

#define SBS_ABOUT_ sizeof (SBS_ABOUT)

// =================================================================
// VERSION INFO STRUCTURES
// =================================================================

#define VS_HEADER(_n)   \
struct _VS_HEADER_##_n  \
    {                   \
    WORD wLength;       \
    WORD wValueLength;  \
    WORD wType;         \
    WORD awKey [_n];    \
    }

typedef VS_HEADER ( 0) VS_HEADER,    *PVS_HEADER;
typedef VS_HEADER ( 1) VS_HEADER_01, *PVS_HEADER_01;
typedef VS_HEADER ( 9) VS_HEADER_09, *PVS_HEADER_09;
typedef VS_HEADER (13) VS_HEADER_13, *PVS_HEADER_13;
typedef VS_HEADER (15) VS_HEADER_15, *PVS_HEADER_15;
typedef VS_HEADER (17) VS_HEADER_17, *PVS_HEADER_17;

// -----------------------------------------------------------------

typedef struct _VS_STRING
    {
    VS_HEADER_01 Header; // key and value
    WORD         awData [];
    }
    VS_STRING, *PVS_STRING, **PPVS_STRING;

#define VS_STRING_ OFFSET (VS_STRING, awData)

// -----------------------------------------------------------------

typedef struct _VS_STRINGTABLE
    {
    VS_HEADER_09 Header; // language and code page
    VS_STRING    String;
    }
    VS_STRINGTABLE, *PVS_STRINGTABLE, **PPVS_STRINGTABLE;

#define VS_STRINGTABLE_ sizeof (VS_STRINGTABLE)

// -----------------------------------------------------------------

typedef struct _VS_STRINGFILEINFO
    {
    VS_HEADER_15   Header; // "StringFileInfo"
    VS_STRINGTABLE StringTable;
    }
    VS_STRINGFILEINFO, *PVS_STRINGFILEINFO, **PPVS_STRINGFILEINFO;

#define VS_STRINGFILEINFO_ sizeof (VS_STRINGFILEINFO)

// -----------------------------------------------------------------

typedef struct _VS_TRANSLATION
    {
    WORD wLanguage;
    WORD wCodePage;
    }
    VS_TRANSLATION, *PVS_TRANSLATION, **PPVS_TRANSLATION;

#define VS_TRANSLATION_ sizeof (VS_TRANSLATION)

// -----------------------------------------------------------------

typedef struct _VS_VAR
    {
    VS_HEADER_13   Header; // "Translation" + padding
    VS_TRANSLATION Translation [];
    }
    VS_VAR, *PVS_VAR, **PPVS_VAR;

#define VS_VAR_ OFFSET (VS_VAR, Translation)

// -----------------------------------------------------------------

typedef struct _VS_VARFILEINFO
    {
    VS_HEADER_13 Header; // "VarFileInfo" + padding
    VS_VAR       Var;
    }
    VS_VARFILEINFO, *PVS_VARFILEINFO, **PPVS_VARFILEINFO;

#define VS_VARFILEINFO_ sizeof (VS_VARFILEINFO)

// -----------------------------------------------------------------

typedef struct _VS_VERSIONINFO
    {
    VS_HEADER_17     Header; // "VS_VERSION_INFO" + padding
    VS_FIXEDFILEINFO FixedFileInfo;
    BYTE             abData [];
    }
    VS_VERSIONINFO, *PVS_VERSIONINFO, **PPVS_VERSIONINFO;

#define VS_VERSIONINFO_ OFFSET (VS_VERSIONINFO, abData)

// -----------------------------------------------------------------

typedef struct _VS_CODE_PAGE
    {
    DWORD dId;
    PBYTE pbName;
    }
    VS_CODE_PAGE, *PVS_CODE_PAGE, **PPVS_CODE_PAGE;

#define VS_CODE_PAGE_ sizeof (VS_CODE_PAGE)

// -----------------------------------------------------------------

typedef struct _VS_VERSIONQUAD
    {
    union
        {
        struct
            {
            QWORD qVersion;
            };
        struct
            {
            DWORD dVersionL;
            DWORD dVersionH;
            };
        struct
            {
            WORD wVersionLL;
            WORD wVersionL;
            WORD wVersionH;
            WORD wVersionHH;
            };
        };
    }
    VS_VERSIONQUAD, *PVS_VERSIONQUAD, **PPVS_VERSIONQUAD;

#define VS_VERSIONQUAD_ sizeof (VS_VERSIONQUAD)

// -----------------------------------------------------------------

typedef struct _VS_VERSIONDATA
    {
    VS_VERSIONQUAD vvqFile;
    VS_VERSIONQUAD vvqProduct;
    DWORD          dLanguage;
    DWORD          dCodePage;
    DWORD          dTableIndex;
    DWORD          dTableCount;
    union
        {
        PTBYTE     ptLanguage;
        PBYTE      pbLanguage;
        PWORD      pwLanguage;
        };
    union
        {
        PTBYTE     ptCodePage;
        PBYTE      pbCodePage;
        PWORD      pwCodePage;
        };
    union
        {
        PTBYTE     ptComments;
        PBYTE      pbComments;
        PWORD      pwComments;
        PVS_STRING pvsComments;
        };
    union
        {
        PTBYTE     ptCompanyName;
        PBYTE      pbCompanyName;
        PWORD      pwCompanyName;
        PVS_STRING pvsCompanyName;
        };
    union
        {
        PTBYTE     ptFileDescription;
        PBYTE      pbFileDescription;
        PWORD      pwFileDescription;
        PVS_STRING pvsFileDescription;
        };
    union
        {
        PTBYTE     ptFileVersion;
        PBYTE      pbFileVersion;
        PWORD      pwFileVersion;
        PVS_STRING pvsFileVersion;
        };
    union
        {
        PTBYTE     ptInternalName;
        PBYTE      pbInternalName;
        PWORD      pwInternalName;
        PVS_STRING pvsInternalName;
        };
    union
        {
        PTBYTE     ptLegalCopyright;
        PBYTE      pbLegalCopyright;
        PWORD      pwLegalCopyright;
        PVS_STRING pvsLegalCopyright;
        };
    union
        {
        PTBYTE     ptLegalTrademarks;
        PBYTE      pbLegalTrademarks;
        PWORD      pwLegalTrademarks;
        PVS_STRING pvsLegalTrademarks;
        };
    union
        {
        PTBYTE     ptOriginalFilename;
        PBYTE      pbOriginalFilename;
        PWORD      pwOriginalFilename;
        PVS_STRING pvsOriginalFilename;
        };
    union
        {
        PTBYTE     ptPrivateBuild;
        PBYTE      pbPrivateBuild;
        PWORD      pwPrivateBuild;
        PVS_STRING pvsPrivateBuild;
        };
    union
        {
        PTBYTE     ptProductName;
        PBYTE      pbProductName;
        PWORD      pwProductName;
        PVS_STRING pvsProductName;
        };
    union
        {
        PTBYTE     ptProductVersion;
        PBYTE      pbProductVersion;
        PWORD      pwProductVersion;
        PVS_STRING pvsProductVersion;
        };
    union
        {
        PTBYTE     ptSpecialBuild;
        PBYTE      pbSpecialBuild;
        PWORD      pwSpecialBuild;
        PVS_STRING pvsSpecialBuild;
        };
    WORD wReserved;
    WORD awBuffer [];
    }
    VS_VERSIONDATA, *PVS_VERSIONDATA, **PPVS_VERSIONDATA;

#define VS_VERSIONDATA_ OFFSET (VS_VERSIONDATA, awBuffer)

#define VS_VERSIONDATA_A(_c) (VS_VERSIONDATA_ +  (_c)         )
#define VS_VERSIONDATA_W(_c) (VS_VERSIONDATA_ + ((_c) * WORD_))

// =================================================================
// SERVICE CONTROL MANAGER
// =================================================================

typedef BOOL
        (WINAPI *SC_CLOSE_SERVICE_HANDLE)
                (SC_HANDLE              hSCObject);

typedef BOOL
        (WINAPI *SC_CONTROL_SERVICE)
                (SC_HANDLE              hService,
                 DWORD                  dwControl,
                 LPSERVICE_STATUS       lpServiceStatus);

typedef SC_HANDLE
        (WINAPI *SC_CREATE_SERVICE)
                (SC_HANDLE              hSCManager,
                 LPCWSTR                lpServiceName,
                 LPCWSTR                lpDisplayName,
                 DWORD                  dwDesiredAccess,
                 DWORD                  dwServiceType,
                 DWORD                  dwStartType,
                 DWORD                  dwErrorControl,
                 LPCWSTR                lpBinaryPathName,
                 LPCWSTR                lpLoadOrderGroup,
                 LPDWORD                lpdwTagId,
                 LPCWSTR                lpDependencies,
                 LPCWSTR                lpServiceStartName,
                 LPCWSTR                lpPassword);

typedef BOOL
        (WINAPI *SC_DELETE_SERVICE)
                (SC_HANDLE   hService);

typedef BOOL
        (WINAPI *SC_ENUM_SERVICE_STATUS)
                (SC_HANDLE              hSCManager,
                 DWORD                  dwServiceType,
                 DWORD                  dwServiceState,
                 LPENUM_SERVICE_STATUSW lpServices,
                 DWORD                  cbBufSize,
                 LPDWORD                pcbBytesNeeded,
                 LPDWORD                lpServicesReturned,
                 LPDWORD                lpResumeHandle);

typedef SC_HANDLE
        (WINAPI *SC_OPEN_SC_MANAGER)
                (LPCWSTR                lpMachineName,
                 LPCWSTR                lpDatabaseName,
                 DWORD                  dwDesiredAccess);

typedef SC_HANDLE
        (WINAPI *SC_OPEN_SERVICE)
            (SC_HANDLE                  hSCManager,
             LPCWSTR                    lpServiceName,
             DWORD                      dwDesiredAccess);

typedef BOOL
        (WINAPI *SC_QUERY_SERVICE_STATUS)
                (SC_HANDLE              hService,
                 LPSERVICE_STATUS       lpServiceStatus);

typedef BOOL
        (WINAPI *SC_START_SERVICE)
                (SC_HANDLE              hService,
                 DWORD                  dwNumServiceArgs,
                 LPCWSTR               *lpServiceArgVectors);

// -----------------------------------------------------------------

typedef struct _SBS_SCM
    {
    HMODULE                 hModule;
    SC_HANDLE               hManager;
    SC_CLOSE_SERVICE_HANDLE CloseServiceHandle;
    SC_CONTROL_SERVICE      ControlService;
    SC_CREATE_SERVICE       CreateService;
    SC_DELETE_SERVICE       DeleteService;
    SC_ENUM_SERVICE_STATUS  EnumServicesStatus;
    SC_OPEN_SC_MANAGER      OpenSCManager;
    SC_OPEN_SERVICE         OpenService;
    SC_QUERY_SERVICE_STATUS QueryServiceStatus;
    SC_START_SERVICE        StartService;
    }
    SBS_SCM, *PSBS_SCM, **PPSBS_SCM,
             *HSCM,     **PHSCM;

#define SBS_SCM_ sizeof (SBS_SCM)

// =================================================================
// CONDITIONAL ANSI/UNICODE SYMBOLS
// =================================================================

#ifdef  UNICODE

#define SBS_IS_UNICODE              TRUE

#define SbsDecimalRead              SbsDecimalReadW
#define SbsHexTest                  SbsHexTestW
#define SbsHexNibble                SbsHexNibbleW
#define SbsHexByte                  SbsHexByteW
#define SbsHexBytes                 SbsHexBytesW
#define SbsHexWord                  SbsHexWordW
#define SbsHexDword                 SbsHexDwordW
#define SbsHexEncode                SbsHexEncodeW
#define SbsHexDecode                SbsHexDecodeW
#define SbsMatch                    SbsMatchW
#define SbsTextData                 SbsTextDataW
#define SbsTextCreate               SbsTextCreateW
#define SbsTextRelease              SbsTextReleaseW
#define SbsTextWrite                SbsTextWriteW
#define SbsTextAnsi                 SbsTextAnsiW
#define SbsTextAscii                SbsTextAsciiW
#define SbsTextCustom               SbsTextCustomW
#define SbsTextFill                 SbsTextFillW
#define SbsTextNumber               SbsTextNumberW
#define SbsTextDword                SbsTextDwordW
#define SbsTextLong                 SbsTextLongW
#define SbsTextFormat               SbsTextFormatW
#define SbsBstrNew                  SbsBstrNewW
#define SbsClipboardCopyText        SbsClipboardCopyTextW
#define SbsRegistryTest             SbsRegistryTestW
#define SbsRegistryRoot             SbsRegistryRootW
#define SbsRegistryParse            SbsRegistryParseW
#define SbsRegistryParseEx          SbsRegistryParseExW
#define SbsRegistryOpen             SbsRegistryOpenW
#define SbsRegistryOpenEx           SbsRegistryOpenExW
#define SbsRegistryCreate           SbsRegistryCreateW
#define SbsRegistryCreateEx         SbsRegistryCreateExW
#define SbsRegistryPath             SbsRegistryPathW
#define SbsRegistryPathOpen         SbsRegistryPathOpenW
#define SbsRegistryPathCreate       SbsRegistryPathCreateW
#define SbsRegistryPathRead         SbsRegistryPathReadW
#define SbsRegistryPathWrite        SbsRegistryPathWriteW
#define SbsRegistryPathDelete       SbsRegistryPathDeleteW
#define SbsRegistryData             SbsRegistryDataW
#define SbsRegistryRead             SbsRegistryReadW
#define SbsRegistryReadDword        SbsRegistryReadDwordW
#define SbsRegistryReadText         SbsRegistryReadTextW
#define SbsRegistryReadBinary       SbsRegistryReadBinaryW
#define SbsRegistryWrite            SbsRegistryWriteW
#define SbsRegistryWriteDword       SbsRegistryWriteDwordW
#define SbsRegistryWriteText        SbsRegistryWriteTextW
#define SbsRegistryWriteBinary      SbsRegistryWriteBinaryW
#define SbsRegistryDeleteValue      SbsRegistryDeleteValueW
#define SbsSoftwareValue            SbsSoftwareValueW
#define SbsSoftwareReadDword        SbsSoftwareReadDwordW
#define SbsSoftwareReadText         SbsSoftwareReadTextW
#define SbsSoftwareReadBinary       SbsSoftwareReadBinaryW
#define SbsSoftwareWriteDword       SbsSoftwareWriteDwordW
#define SbsSoftwareWriteText        SbsSoftwareWriteTextW
#define SbsSoftwareWriteBinary      SbsSoftwareWriteBinaryW
#define SbsSoftwareDeleteKey        SbsSoftwareDeleteKeyW
#define SbsSoftwareDeleteValue      SbsSoftwareDeleteValueW
#define SbsVersionToken             SbsVersionTokenW
#define SbsVersionBinary            SbsVersionBinaryW
#define SbsVersionText              SbsVersionTextW
#define SbsVersionFile              SbsVersionFileW
#define SbsVersionData              SbsVersionDataW
#define SbsVersionInfo              SbsVersionInfoW
#define SbsVersionTable             SbsVersionTableW
#define SbsVersionTableString       SbsVersionTableStringW
#define SbsVersionString            SbsVersionStringW
#define SbsVersionStringEx          SbsVersionStringExW
#define SbsVersionStringCopy        SbsVersionStringCopyW
#define SbsVersionLanguage          SbsVersionLanguageW
#define SbsVersionCodePage          SbsVersionCodePageW
#define SbsVersionInfoData          SbsVersionInfoDataW
#define SbsVersionBox               SbsVersionBoxW
#define SbsBitmapSave               SbsBitmapSaveW
#define SbsBitmapLoad               SbsBitmapLoadW
#define SbsBitmapDefault            SbsBitmapDefaultW
#define SbsUrlSpace                 SbsUrlSpaceW
#define SbsUrlEscape                SbsUrlEscapeW
#define SbsUrlCount                 SbsUrlCountW
#define SbsUrlEncode                SbsUrlEncodeW
#define SbsUrlDecode                SbsUrlDecodeW
#define SbsUrlFirst                 SbsUrlFirstW
#define SbsCookieFind               SbsCookieFindW
#define SbsCookieFirst              SbsCookieFirstW
#define SbsCookieDelete             SbsCookieDeleteW
#define SbsCookieCreate             SbsCookieCreateW
#define SbsCookieCommit             SbsCookieCommitW
#define SbsCookieTest               SbsCookieTestW
#define SbsCookieParse              SbsCookieParseW
#define SbsCookieCompile            SbsCookieCompileW
#define SbsCookieLoad               SbsCookieLoadW
#define SbsCookieSave               SbsCookieSaveW
#define SbsCookieAssign             SbsCookieAssignW
#define SbsCookieUpdate             SbsCookieUpdateW
#define SbsCookieRemove             SbsCookieRemoveW
#define SbsCookieNew                SbsCookieNewW
#define SbsCookieAppend             SbsCookieAppendW
#define SbsCookieRebuild            SbsCookieRebuildW
#define SbsCookieMerge              SbsCookieMergeW
#define SbsCookieRegister           SbsCookieRegisterW
#define SbsCookieValue              SbsCookieValueW
#define SbsCookieData               SbsCookieDataW
#define SbsCookieDataEx             SbsCookieDataExW
#define SbsCookieUser               SbsCookieUserW
#define SbsCookieName               SbsCookieNameW
#define SbsIniEncode                SbsIniEncodeW
#define SbsIniSpace                 SbsIniSpaceW
#define SbsIniDecoded               SbsIniDecodedW
#define SbsIniDecode                SbsIniDecodeW
#define SbsIniRead                  SbsIniReadW
#define SbsIniReadEx                SbsIniReadExW
#define SbsIniReadRaw               SbsIniReadRawW
#define SbsIniReadCode              SbsIniReadCodeW
#define SbsIniReadHex               SbsIniReadHexW
#define SbsIniReadString            SbsIniReadStringW
#define SbsIniReadStringEx          SbsIniReadStringExW
#define SbsIniReadDword             SbsIniReadDwordW
#define SbsIniReadLong              SbsIniReadLongW
#define SbsIniReadBool              SbsIniReadBoolW
#define SbsIniReadColor             SbsIniReadColorW
#define SbsIniReadFont              SbsIniReadFontW
#define SbsIniReadFontEx            SbsIniReadFontExW
#define SbsIniReadData              SbsIniReadDataW
#define SbsIniWrite                 SbsIniWriteW
#define SbsIniWriteEx               SbsIniWriteExW
#define SbsIniWriteRaw              SbsIniWriteRawW
#define SbsIniWriteCode             SbsIniWriteCodeW
#define SbsIniWriteHex              SbsIniWriteHexW
#define SbsIniWriteString           SbsIniWriteStringW
#define SbsIniWriteDword            SbsIniWriteDwordW
#define SbsIniWriteLong             SbsIniWriteLongW
#define SbsIniWriteBool             SbsIniWriteBoolW
#define SbsIniWriteColor            SbsIniWriteColorW
#define SbsIniWriteFont             SbsIniWriteFontW
#define SbsIniWriteData             SbsIniWriteDataW
#define SbsIniDeleteKey             SbsIniDeleteKeyW
#define SbsIniDeleteKeys            SbsIniDeleteKeysW
#define SbsIniDeleteSection         SbsIniDeleteSectionW
#define SbsIniDeleteAll             SbsIniDeleteAllW
#define SbsProcessRun               SbsProcessRunW
#define SbsThreadOpen               SbsThreadOpenW
#define SbsThreadUpdate             SbsThreadUpdateW
#define SbsWindowNew                SbsWindowNewW
#define SbsWindowCreate             SbsWindowCreateW
#define SbsWindowMain               SbsWindowMainW
#define SbsWindowIdle               SbsWindowIdleW
#define SbsWindowLabel              SbsWindowLabelW
#define SbsWindowMenuRead           SbsWindowMenuReadW
#define SbsWindowFont               SbsWindowFontW
#define SbsDialogRead               SbsDialogReadW
#define SbsDialogWrite              SbsDialogWriteW
#define SbsDialogLabel              SbsDialogLabelW
#define SbsDialogCopy               SbsDialogCopyW
#define SbsAboutBox                 SbsAboutBoxW
#define SbsStatusCreate             SbsStatusCreateW
#define SbsStatusUpdate             SbsStatusUpdateW
#define SbsSelectFont               SbsSelectFontW
#define SbsSelectBrush              SbsSelectBrushW
#define SbsSelectFiles              SbsSelectFilesW
#define SbsSelectFile               SbsSelectFileW
#define SbsDrawMetrics              SbsDrawMetricsW
#define SbsDrawText                 SbsDrawTextW
#define SbsDrawBox                  SbsDrawBoxW
#define SbsDrawButton               SbsDrawButtonW
#define SbsDrawInfo                 SbsDrawInfoW
#define SbsFontObject               SbsFontObjectW
#define SbsFontSystem               SbsFontSystemW
#define SbsFontFixedsys             SbsFontFixedsysW
#define SbsFontTerminal             SbsFontTerminalW
#define SbsFontSymbol               SbsFontSymbolW
#define SbsFontStandard             SbsFontStandardW
#define SbsFontCode                 SbsFontCodeW
#define SbsTimeText                 SbsTimeTextW
#define SbsTimeTextUtc              SbsTimeTextUtcW
#define SbsTimeTextLocal            SbsTimeTextLocalW
#define SbsGuidText                 SbsGuidTextW
#define SbsGuidTextEx               SbsGuidTextExW
#define SbsGuidBinary               SbsGuidBinaryW
#define SbsGuidValueRead            SbsGuidValueReadW
#define SbsGuidValueWrite           SbsGuidValueWriteW
#define SbsGuidReadText             SbsGuidReadTextW
#define SbsGuidWriteText            SbsGuidWriteTextW
#define SbsGuidDeleteKey            SbsGuidDeleteKeyW
#define SbsGuidDeleteValue          SbsGuidDeleteValueW
#define SbsCrc32Char                SbsCrc32CharW
#define SbsCrc32Text                SbsCrc32TextW
#define SbsRandomText               SbsRandomTextW
#define SbsRtlVersionTest           SbsRtlVersionTestW

#else   // #ifdef UNICODE

#define SBS_IS_UNICODE              FALSE

#define SbsDecimalRead              SbsDecimalReadA
#define SbsHexTest                  SbsHexTestA
#define SbsHexNibble                SbsHexNibbleA
#define SbsHexByte                  SbsHexByteA
#define SbsHexBytes                 SbsHexBytesA
#define SbsHexWord                  SbsHexWordA
#define SbsHexDword                 SbsHexDwordA
#define SbsHexEncode                SbsHexEncodeA
#define SbsHexDecode                SbsHexDecodeA
#define SbsMatch                    SbsMatchA
#define SbsTextData                 SbsTextDataA
#define SbsTextCreate               SbsTextCreateA
#define SbsTextRelease              SbsTextReleaseA
#define SbsTextWrite                SbsTextWriteA
#define SbsTextAnsi                 SbsTextAnsiA
#define SbsTextAscii                SbsTextAsciiA
#define SbsTextCustom               SbsTextCustomA
#define SbsTextFill                 SbsTextFillA
#define SbsTextNumber               SbsTextNumberA
#define SbsTextDword                SbsTextDwordA
#define SbsTextLong                 SbsTextLongA
#define SbsTextFormat               SbsTextFormatA
#define SbsBstrNew                  SbsBstrNewA
#define SbsClipboardCopyText        SbsClipboardCopyTextA
#define SbsRegistryTest             SbsRegistryTestA
#define SbsRegistryRoot             SbsRegistryRootA
#define SbsRegistryParse            SbsRegistryParseA
#define SbsRegistryParseEx          SbsRegistryParseExA
#define SbsRegistryOpen             SbsRegistryOpenA
#define SbsRegistryOpenEx           SbsRegistryOpenExA
#define SbsRegistryCreate           SbsRegistryCreateA
#define SbsRegistryCreateEx         SbsRegistryCreateExA
#define SbsRegistryPath             SbsRegistryPathA
#define SbsRegistryPathOpen         SbsRegistryPathOpenA
#define SbsRegistryPathCreate       SbsRegistryPathCreateA
#define SbsRegistryPathRead         SbsRegistryPathReadA
#define SbsRegistryPathWrite        SbsRegistryPathWriteA
#define SbsRegistryPathDelete       SbsRegistryPathDeleteA
#define SbsRegistryData             SbsRegistryDataA
#define SbsRegistryRead             SbsRegistryReadA
#define SbsRegistryReadDword        SbsRegistryReadDwordA
#define SbsRegistryReadText         SbsRegistryReadTextA
#define SbsRegistryReadBinary       SbsRegistryReadBinaryA
#define SbsRegistryWrite            SbsRegistryWriteA
#define SbsRegistryWriteDword       SbsRegistryWriteDwordA
#define SbsRegistryWriteText        SbsRegistryWriteTextA
#define SbsRegistryWriteBinary      SbsRegistryWriteBinaryA
#define SbsRegistryDeleteValue      SbsRegistryDeleteValueA
#define SbsSoftwareValue            SbsSoftwareValueA
#define SbsSoftwareReadDword        SbsSoftwareReadDwordA
#define SbsSoftwareReadText         SbsSoftwareReadTextA
#define SbsSoftwareReadBinary       SbsSoftwareReadBinaryA
#define SbsSoftwareWriteDword       SbsSoftwareWriteDwordA
#define SbsSoftwareWriteText        SbsSoftwareWriteTextA
#define SbsSoftwareWriteBinary      SbsSoftwareWriteBinaryA
#define SbsSoftwareDeleteKey        SbsSoftwareDeleteKeyA
#define SbsSoftwareDeleteValue      SbsSoftwareDeleteValueA
#define SbsVersionToken             SbsVersionTokenA
#define SbsVersionBinary            SbsVersionBinaryA
#define SbsVersionText              SbsVersionTextA
#define SbsVersionFile              SbsVersionFileA
#define SbsVersionData              SbsVersionDataA
#define SbsVersionInfo              SbsVersionInfoA
#define SbsVersionTable             SbsVersionTableA
#define SbsVersionTableString       SbsVersionTableStringA
#define SbsVersionString            SbsVersionStringA
#define SbsVersionStringEx          SbsVersionStringExA
#define SbsVersionStringCopy        SbsVersionStringCopyA
#define SbsVersionLanguage          SbsVersionLanguageA
#define SbsVersionCodePage          SbsVersionCodePageA
#define SbsVersionInfoData          SbsVersionInfoDataA
#define SbsVersionBox               SbsVersionBoxA
#define SbsBitmapSave               SbsBitmapSaveA
#define SbsBitmapLoad               SbsBitmapLoadA
#define SbsBitmapDefault            SbsBitmapDefaultA
#define SbsUrlSpace                 SbsUrlSpaceA
#define SbsUrlEscape                SbsUrlEscapeA
#define SbsUrlCount                 SbsUrlCountA
#define SbsUrlEncode                SbsUrlEncodeA
#define SbsUrlDecode                SbsUrlDecodeA
#define SbsUrlFirst                 SbsUrlFirstA
#define SbsCookieFind               SbsCookieFindA
#define SbsCookieFirst              SbsCookieFirstA
#define SbsCookieDelete             SbsCookieDeleteA
#define SbsCookieCreate             SbsCookieCreateA
#define SbsCookieCommit             SbsCookieCommitA
#define SbsCookieTest               SbsCookieTestA
#define SbsCookieParse              SbsCookieParseA
#define SbsCookieCompile            SbsCookieCompileA
#define SbsCookieLoad               SbsCookieLoadA
#define SbsCookieSave               SbsCookieSaveA
#define SbsCookieAssign             SbsCookieAssignA
#define SbsCookieUpdate             SbsCookieUpdateA
#define SbsCookieRemove             SbsCookieRemoveA
#define SbsCookieNew                SbsCookieNewA
#define SbsCookieAppend             SbsCookieAppendA
#define SbsCookieRebuild            SbsCookieRebuildA
#define SbsCookieMerge              SbsCookieMergeA
#define SbsCookieRegister           SbsCookieRegisterA
#define SbsCookieValue              SbsCookieValueA
#define SbsCookieData               SbsCookieDataA
#define SbsCookieDataEx             SbsCookieDataExA
#define SbsCookieUser               SbsCookieUserA
#define SbsCookieName               SbsCookieNameA
#define SbsIniEncode                SbsIniEncodeA
#define SbsIniSpace                 SbsIniSpaceA
#define SbsIniDecoded               SbsIniDecodedA
#define SbsIniDecode                SbsIniDecodeA
#define SbsIniRead                  SbsIniReadA
#define SbsIniReadEx                SbsIniReadExA
#define SbsIniReadRaw               SbsIniReadRawA
#define SbsIniReadCode              SbsIniReadCodeA
#define SbsIniReadHex               SbsIniReadHexA
#define SbsIniReadString            SbsIniReadStringA
#define SbsIniReadStringEx          SbsIniReadStringExA
#define SbsIniReadDword             SbsIniReadDwordA
#define SbsIniReadLong              SbsIniReadLongA
#define SbsIniReadBool              SbsIniReadBoolA
#define SbsIniReadColor             SbsIniReadColorA
#define SbsIniReadFont              SbsIniReadFontA
#define SbsIniReadFontEx            SbsIniReadFontExA
#define SbsIniReadData              SbsIniReadDataA
#define SbsIniWrite                 SbsIniWriteA
#define SbsIniWriteEx               SbsIniWriteExA
#define SbsIniWriteRaw              SbsIniWriteRawA
#define SbsIniWriteCode             SbsIniWriteCodeA
#define SbsIniWriteHex              SbsIniWriteHexA
#define SbsIniWriteString           SbsIniWriteStringA
#define SbsIniWriteDword            SbsIniWriteDwordA
#define SbsIniWriteLong             SbsIniWriteLongA
#define SbsIniWriteBool             SbsIniWriteBoolA
#define SbsIniWriteColor            SbsIniWriteColorA
#define SbsIniWriteFont             SbsIniWriteFontA
#define SbsIniWriteData             SbsIniWriteDataA
#define SbsIniDeleteKey             SbsIniDeleteKeyA
#define SbsIniDeleteKeys            SbsIniDeleteKeysA
#define SbsIniDeleteSection         SbsIniDeleteSectionA
#define SbsIniDeleteAll             SbsIniDeleteAllA
#define SbsProcessRun               SbsProcessRunA
#define SbsThreadOpen               SbsThreadOpenA
#define SbsThreadUpdate             SbsThreadUpdateA
#define SbsWindowNew                SbsWindowNewA
#define SbsWindowCreate             SbsWindowCreateA
#define SbsWindowMain               SbsWindowMainA
#define SbsWindowIdle               SbsWindowIdleA
#define SbsWindowLabel              SbsWindowLabelA
#define SbsWindowMenuRead           SbsWindowMenuReadA
#define SbsWindowFont               SbsWindowFontA
#define SbsDialogRead               SbsDialogReadA
#define SbsDialogWrite              SbsDialogWriteA
#define SbsDialogLabel              SbsDialogLabelA
#define SbsDialogCopy               SbsDialogCopyA
#define SbsAboutBox                 SbsAboutBoxA
#define SbsStatusCreate             SbsStatusCreateA
#define SbsStatusUpdate             SbsStatusUpdateA
#define SbsSelectFont               SbsSelectFontA
#define SbsSelectBrush              SbsSelectBrushA
#define SbsSelectFiles              SbsSelectFilesA
#define SbsSelectFile               SbsSelectFileA
#define SbsDrawMetrics              SbsDrawMetricsA
#define SbsDrawText                 SbsDrawTextA
#define SbsDrawBox                  SbsDrawBoxA
#define SbsDrawButton               SbsDrawButtonA
#define SbsDrawInfo                 SbsDrawInfoA
#define SbsFontObject               SbsFontObjectA
#define SbsFontSystem               SbsFontSystemA
#define SbsFontFixedsys             SbsFontFixedsysA
#define SbsFontTerminal             SbsFontTerminalA
#define SbsFontSymbol               SbsFontSymbolA
#define SbsFontStandard             SbsFontStandardA
#define SbsFontCode                 SbsFontCodeA
#define SbsTimeText                 SbsTimeTextA
#define SbsTimeTextUtc              SbsTimeTextUtcA
#define SbsTimeTextLocal            SbsTimeTextLocalA
#define SbsGuidText                 SbsGuidTextA
#define SbsGuidTextEx               SbsGuidTextExA
#define SbsGuidBinary               SbsGuidBinaryA
#define SbsGuidValueRead            SbsGuidValueReadA
#define SbsGuidValueWrite           SbsGuidValueWriteA
#define SbsGuidReadText             SbsGuidReadTextA
#define SbsGuidWriteText            SbsGuidWriteTextA
#define SbsGuidDeleteKey            SbsGuidDeleteKeyA
#define SbsGuidDeleteValue          SbsGuidDeleteValueA
#define SbsCrc32Char                SbsCrc32CharA
#define SbsCrc32Text                SbsCrc32TextA
#define SbsRandomText               SbsRandomTextA
#define SbsRtlVersionTest           SbsRtlVersionTestA

#endif  // #ifdef UNICODE

// =================================================================
// API PROTOTYPES
// =================================================================

#ifdef __cplusplus
extern "C" {
#endif

// -----------------------------------------------------------------

PWORD WINAPI SbsConvertA2W (PBYTE pbData);

PBYTE WINAPI SbsConvertW2A (PWORD pwData);

DWORD WINAPI SbsSizeDecimal (DWORD dNumber);

DWORD WINAPI SbsSizeDivide (DWORD dShift,
                            DWORD dSize,
                            BOOL  fRoundUp,
                            BOOL  fRoundDown);

DWORD WINAPI SbsSizeKB (DWORD dBytes,
                        BOOL  fRoundUp,
                        BOOL  fRoundDown);

DWORD WINAPI SbsSizeMB (DWORD dBytes,
                        BOOL  fRoundUp,
                        BOOL  fRoundDown);

DWORD WINAPI SbsSizePercent (DWORD dPart,
                             DWORD dTotal);

DWORD WINAPI SbsDecimalReadA (PBYTE  pbData,
                              PDWORD pdData);

DWORD WINAPI SbsDecimalReadW (PWORD  pwData,
                              PDWORD pdData);

BOOL WINAPI SbsHexTestA (BYTE bData);

BOOL WINAPI SbsHexTestW (WORD wData);

BYTE WINAPI SbsHexNibbleA (BYTE bData);

BYTE WINAPI SbsHexNibbleW (WORD wData);

BYTE WINAPI SbsHexByteA (BYTE bHigh,
                         BYTE bLow);

BYTE WINAPI SbsHexByteW (WORD wHigh,
                         WORD wLow);

DWORD WINAPI SbsHexBytesA (PBYTE pbHex,
                           PVOID pData,
                           DWORD dData);

DWORD WINAPI SbsHexBytesW (PWORD pwHex,
                           PVOID pData,
                           DWORD dData);

DWORD WINAPI SbsHexWordA (PBYTE pbHex,
                          PWORD pwData);

DWORD WINAPI SbsHexWordW (PWORD pwHex,
                          PWORD pwData);

DWORD WINAPI SbsHexDwordA (PBYTE  pbHex,
                           PDWORD pdData);

DWORD WINAPI SbsHexDwordW (PWORD  pwHex,
                           PDWORD pdData);

PBYTE WINAPI SbsHexEncodeA (PVOID  pData,
                            PDWORD pdData);

PWORD WINAPI SbsHexEncodeW (PVOID  pData,
                            PDWORD pdData);

PVOID WINAPI SbsHexDecodeA (PBYTE  pbData,
                            PDWORD pdData);

PVOID WINAPI SbsHexDecodeW (PWORD  pwData,
                            PDWORD pdData);

BOOL WINAPI SbsMatchA (PBYTE pbFilter,
                       PBYTE pbData,
                       BOOL  fIgnoreCase);

BOOL WINAPI SbsMatchW (PWORD pwFilter,
                       PWORD pwData,
                       BOOL  fIgnoreCase);

BOOL WINAPI SbsLockSet (PSBS_LOCK psl,
                        BOOL      fBeep);

VOID WINAPI SbsLockReset (PSBS_LOCK psl);

DWORD WINAPI SbsBufferBlock (DWORD dData);

PSBS_BUFFER WINAPI SbsBufferCreate (DWORD dSize);

PSBS_BUFFER WINAPI SbsBufferDestroy (PSBS_BUFFER psb);

PSBS_BUFFER WINAPI SbsBufferResize (PSBS_BUFFER psb,
                                    DWORD       dData);

PVOID WINAPI SbsBufferRelease (PSBS_BUFFER psb,
                               PDWORD      pdData);

PSBS_BUFFER WINAPI SbsBufferWrite (PSBS_BUFFER psb,
                                   PVOID       pData,
                                   DWORD       dData);

PSBS_BUFFER WINAPI SbsBufferByte (PSBS_BUFFER psb,
                                  BYTE        bData,
                                  DWORD       dCount);

PSBS_BUFFER WINAPI SbsBufferWord (PSBS_BUFFER psb,
                                  WORD        wData,
                                  DWORD       dCount);

PSBS_BUFFER WINAPI SbsBufferDword (PSBS_BUFFER psb,
                                   DWORD       dData,
                                   DWORD       dCount);

DWORD WINAPI SbsTextDataA (PBYTE pbData,
                           DWORD dData);

DWORD WINAPI SbsTextDataW (PWORD pwData,
                           DWORD dData);

PSBS_BUFFER WINAPI SbsTextCreateA (DWORD dSize);

PSBS_BUFFER WINAPI SbsTextCreateW (DWORD dSize);

PSBS_BUFFER WINAPI SbsTextDestroy (PSBS_BUFFER psb);

PBYTE WINAPI SbsTextReleaseA (PSBS_BUFFER psb,
                              PDWORD      pdData);

PWORD WINAPI SbsTextReleaseW (PSBS_BUFFER psb,
                              PDWORD      pdData);

PSBS_BUFFER WINAPI SbsTextWriteA (PSBS_BUFFER psb,
                                  PBYTE       pbData,
                                  DWORD       dData);

PSBS_BUFFER WINAPI SbsTextWriteW (PSBS_BUFFER psb,
                                  PWORD       pwData,
                                  DWORD       dData);

PSBS_BUFFER WINAPI SbsTextAnsiA (PSBS_BUFFER psb,
                                 PBYTE       pbData,
                                 DWORD       dData);

PSBS_BUFFER WINAPI SbsTextAnsiW (PSBS_BUFFER psb,
                                 PWORD       pwData,
                                 DWORD       dData);

PSBS_BUFFER WINAPI SbsTextAsciiA (PSBS_BUFFER psb,
                                  PBYTE       pbData,
                                  DWORD       dData);

PSBS_BUFFER WINAPI SbsTextAsciiW (PSBS_BUFFER psb,
                                  PWORD       pwData,
                                  DWORD       dData);

PSBS_BUFFER WINAPI SbsTextCustomA (PSBS_BUFFER psb,
                                   PBYTE       pbData,
                                   DWORD       dData,
                                   PBYTE       pbTable);

PSBS_BUFFER WINAPI SbsTextCustomW (PSBS_BUFFER psb,
                                   PWORD       pwData,
                                   DWORD       dData,
                                   PBYTE       pbTable);

PSBS_BUFFER WINAPI SbsTextFillA (PSBS_BUFFER psb,
                                 BYTE        bData,
                                 DWORD       dCount);

PSBS_BUFFER WINAPI SbsTextFillW (PSBS_BUFFER psb,
                                 WORD        wData,
                                 DWORD       dCount);

PSBS_BUFFER WINAPI SbsTextNumberA (PSBS_BUFFER psb,
                                   DWORD       dData,
                                   DWORD       dLimit,
                                   BOOL        fZero,
                                   BOOL        fSigned);

PSBS_BUFFER WINAPI SbsTextNumberW (PSBS_BUFFER psb,
                                   DWORD       dData,
                                   DWORD       dLimit,
                                   BOOL        fZero,
                                   BOOL        fSigned);

PSBS_BUFFER WINAPI SbsTextDwordA (PSBS_BUFFER psb,
                                  DWORD       dData,
                                  DWORD       dLimit,
                                  BOOL        fZero);

PSBS_BUFFER WINAPI SbsTextDwordW (PSBS_BUFFER psb,
                                  DWORD       dData,
                                  DWORD       dLimit,
                                  BOOL        fZero);

PSBS_BUFFER WINAPI SbsTextLongA (PSBS_BUFFER psb,
                                 LONG        lData,
                                 DWORD       dLimit,
                                 BOOL        fZero);

PSBS_BUFFER WINAPI SbsTextLongW (PSBS_BUFFER psb,
                                 LONG        lData,
                                 DWORD       dLimit,
                                 BOOL        fZero);

PSBS_BUFFER WINAPI SbsTextFormatA (PSBS_BUFFER psb,
                                   PBYTE       pbFormat,
                                   ...);

PSBS_BUFFER WINAPI SbsTextFormatW (PSBS_BUFFER psb,
                                   PWORD       pwFormat,
                                   ...);

DWORD WINAPI SbsBstrSize (DWORD dBytes);

PSBS_BSTR WINAPI SbsBstrBase (BSTR bs);

BSTR WINAPI SbsBstrFree (BSTR bs);

BSTR WINAPI SbsBstrNewA (PBYTE pbData);

BSTR WINAPI SbsBstrNewW (PWORD pwData);

BSTR WINAPI SbsBstrClone (BSTR bs);

BOOL WINAPI SbsClipboardCopy (HWND  hWnd,
                              DWORD dFormat,
                              PVOID pData,
                              DWORD dData);

BOOL WINAPI SbsClipboardCopyTextA (HWND  hWnd,
                                   PBYTE pbData);

BOOL WINAPI SbsClipboardCopyTextW (HWND  hWnd,
                                   PWORD pwData);

BOOL WINAPI SbsRegistryTestA (PBYTE pbRoot,
                              PBYTE pbTest);

BOOL WINAPI SbsRegistryTestW (PWORD pwRoot,
                              PWORD pwTest);

BOOL WINAPI SbsRegistryRootA (PBYTE pbRoot,
                              PHKEY phk);

BOOL WINAPI SbsRegistryRootW (PWORD pwRoot,
                              PHKEY phk);

BOOL WINAPI SbsRegistryParseA (PBYTE  pbPath,
                               PHKEY  phk,
                               PPBYTE ppbRoot,
                               PPBYTE ppbKey,
                               PPBYTE ppbValue);

BOOL WINAPI SbsRegistryParseW (PWORD  pwPath,
                               PHKEY  phk,
                               PPWORD ppwRoot,
                               PPWORD ppwKey,
                               PPWORD ppwValue);

PBYTE WINAPI SbsRegistryParseExA (PBYTE  pbPath,
                                  PHKEY  phk,
                                  PPBYTE ppbRoot,
                                  PPBYTE ppbKey,
                                  PPBYTE ppbValue);

PWORD WINAPI SbsRegistryParseExW (PWORD  pwPath,
                                  PHKEY  phk,
                                  PPWORD ppwRoot,
                                  PPWORD ppwKey,
                                  PPWORD ppwValue);

HKEY WINAPI SbsRegistryClose (HKEY hk);

HKEY WINAPI SbsRegistryOpenA (HKEY  hkBase,
                              PBYTE pbKey);

HKEY WINAPI SbsRegistryOpenW (HKEY  hkBase,
                              PWORD pwKey);

HKEY WINAPI SbsRegistryOpenExA (HKEY  hkBase,
                                DWORD dKeys,
                                PBYTE pbKey,
                                ...);

HKEY WINAPI SbsRegistryOpenExW (HKEY  hkBase,
                                DWORD dKeys,
                                PWORD pwKey,
                                ...);

HKEY WINAPI SbsRegistryCreateA (HKEY  hkBase,
                                PBYTE pbKey);

HKEY WINAPI SbsRegistryCreateW (HKEY  hkBase,
                                PWORD pwKey);

HKEY WINAPI SbsRegistryCreateExA (HKEY  hkBase,
                                  DWORD dKeys,
                                  PBYTE pbKey,
                                  ...);

HKEY WINAPI SbsRegistryCreateExW (HKEY  hkBase,
                                  DWORD dKeys,
                                  PWORD pwKey,
                                  ...);

PSBS_PATH WINAPI SbsRegistryPathA (PBYTE pbPath,
                                   BOOL  fCreate);

PSBS_PATH WINAPI SbsRegistryPathW (PWORD pwPath,
                                   BOOL  fCreate);

PSBS_PATH WINAPI SbsRegistryPathOpenA (PBYTE pbPath);

PSBS_PATH WINAPI SbsRegistryPathOpenW (PWORD pwPath);

PSBS_PATH WINAPI SbsRegistryPathCreateA (PBYTE pbPath);

PSBS_PATH WINAPI SbsRegistryPathCreateW (PWORD pwPath);

PSBS_PATH WINAPI SbsRegistryPathClose (PSBS_PATH psp);

PVOID WINAPI SbsRegistryPathReadA (PBYTE  pbPath,
                                   DWORD  dMode,
                                   PDWORD pdSize);

PVOID WINAPI SbsRegistryPathReadW (PWORD  pwPath,
                                   DWORD  dMode,
                                   PDWORD pdSize);

BOOL WINAPI SbsRegistryPathWriteA (PBYTE pbPath,
                                   DWORD dMode,
                                   PVOID pData);

BOOL WINAPI SbsRegistryPathWriteW (PWORD pwPath,
                                   DWORD dMode,
                                   PVOID pData);

BOOL WINAPI SbsRegistryPathDeleteA (PBYTE pbPath);

BOOL WINAPI SbsRegistryPathDeleteW (PWORD pwPath);

PVOID WINAPI SbsRegistryDataA (HKEY   hk,
                               PBYTE  pbValue,
                               PDWORD pdType,
                               PDWORD pdSize);

PVOID WINAPI SbsRegistryDataW (HKEY   hk,
                               PWORD  pwValue,
                               PDWORD pdType,
                               PDWORD pdSize);

PVOID WINAPI SbsRegistryReadA (HKEY   hk,
                               PBYTE  pbValue,
                               DWORD  dMode,
                               PDWORD pdSize);

PVOID WINAPI SbsRegistryReadW (HKEY   hk,
                               PWORD  pwValue,
                               DWORD  dMode,
                               PDWORD pdSize);

BOOL WINAPI SbsRegistryReadDwordA (HKEY   hk,
                                   PBYTE  pbValue,
                                   PDWORD pdData);

BOOL WINAPI SbsRegistryReadDwordW (HKEY   hk,
                                   PWORD  pwValue,
                                   PDWORD pdData);

PBYTE WINAPI SbsRegistryReadTextA (HKEY   hk,
                                   PBYTE  pbValue,
                                   PDWORD pdSize);

PWORD WINAPI SbsRegistryReadTextW (HKEY   hk,
                                   PWORD  pwValue,
                                   PDWORD pdSize);

PVOID WINAPI SbsRegistryReadBinaryA (HKEY  hk,
                                     PBYTE pbValue,
                                     DWORD dSize);

PVOID WINAPI SbsRegistryReadBinaryW (HKEY  hk,
                                     PWORD pwValue,
                                     DWORD dSize);

BOOL WINAPI SbsRegistryWriteA (HKEY  hk,
                               PBYTE pbValue,
                               DWORD dMode,
                               PVOID pData);

BOOL WINAPI SbsRegistryWriteW (HKEY  hk,
                               PWORD pwValue,
                               DWORD dMode,
                               PVOID pData);

BOOL WINAPI SbsRegistryWriteDwordA (HKEY  hk,
                                    PBYTE pbValue,
                                    DWORD dData);

BOOL WINAPI SbsRegistryWriteDwordW (HKEY  hk,
                                    PWORD pwValue,
                                    DWORD dData);

BOOL WINAPI SbsRegistryWriteTextA (HKEY  hk,
                                   PBYTE pbValue,
                                   PBYTE pbData);

BOOL WINAPI SbsRegistryWriteTextW (HKEY  hk,
                                   PWORD pwValue,
                                   PWORD pwData);

BOOL WINAPI SbsRegistryWriteBinaryA (HKEY  hk,
                                     PBYTE pbValue,
                                     PVOID pData,
                                     DWORD dSize);

BOOL WINAPI SbsRegistryWriteBinaryW (HKEY  hk,
                                     PWORD pwValue,
                                     PVOID pData,
                                     DWORD dSize);

BOOL WINAPI SbsRegistryDeleteValueA (HKEY  hk,
                                     PBYTE pbValue);

BOOL WINAPI SbsRegistryDeleteValueW (HKEY  hk,
                                     PWORD pwValue);

PBYTE WINAPI SbsSoftwareValueA (PBYTE pbFormat,
                                PBYTE pbCompany,
                                PBYTE pbProduct,
                                PBYTE pbVersion,
                                PBYTE pbItem);

PWORD WINAPI SbsSoftwareValueW (PWORD pwFormat,
                                PWORD pwCompany,
                                PWORD pwProduct,
                                PWORD pwVersion,
                                PWORD pwItem);

BOOL WINAPI SbsSoftwareReadDwordA (PBYTE  pbFormat,
                                   PBYTE  pbCompany,
                                   PBYTE  pbProduct,
                                   PBYTE  pbVersion,
                                   PBYTE  pbItem,
                                   PDWORD pdData);

BOOL WINAPI SbsSoftwareReadDwordW (PWORD  pwFormat,
                                   PWORD  pwCompany,
                                   PWORD  pwProduct,
                                   PWORD  pwVersion,
                                   PWORD  pwItem,
                                   PDWORD pdData);

PBYTE WINAPI SbsSoftwareReadTextA (PBYTE  pbFormat,
                                   PBYTE  pbCompany,
                                   PBYTE  pbProduct,
                                   PBYTE  pbVersion,
                                   PBYTE  pbItem,
                                   PDWORD pdSize);

PWORD WINAPI SbsSoftwareReadTextW (PWORD  pwFormat,
                                   PWORD  pwCompany,
                                   PWORD  pwProduct,
                                   PWORD  pwVersion,
                                   PWORD  pwItem,
                                   PDWORD pdSize);

PVOID WINAPI SbsSoftwareReadBinaryA (PBYTE pbFormat,
                                     PBYTE pbCompany,
                                     PBYTE pbProduct,
                                     PBYTE pbVersion,
                                     PBYTE pbItem,
                                     DWORD dSize);

PVOID WINAPI SbsSoftwareReadBinaryW (PWORD pwFormat,
                                     PWORD pwCompany,
                                     PWORD pwProduct,
                                     PWORD pwVersion,
                                     PWORD pwItem,
                                     DWORD dSize);

BOOL WINAPI SbsSoftwareWriteDwordA (PBYTE pbFormat,
                                    PBYTE pbCompany,
                                    PBYTE pbProduct,
                                    PBYTE pbVersion,
                                    PBYTE pbItem,
                                    DWORD dData);

BOOL WINAPI SbsSoftwareWriteDwordW (PWORD pwFormat,
                                    PWORD pwCompany,
                                    PWORD pwProduct,
                                    PWORD pwVersion,
                                    PWORD pwItem,
                                    DWORD dData);

BOOL WINAPI SbsSoftwareWriteTextA (PBYTE pbFormat,
                                   PBYTE pbCompany,
                                   PBYTE pbProduct,
                                   PBYTE pbVersion,
                                   PBYTE pbItem,
                                   PBYTE pbData);

BOOL WINAPI SbsSoftwareWriteTextW (PWORD pwFormat,
                                   PWORD pwCompany,
                                   PWORD pwProduct,
                                   PWORD pwVersion,
                                   PWORD pwItem,
                                   PWORD pwData);

BOOL WINAPI SbsSoftwareWriteBinaryA (PBYTE pbFormat,
                                     PBYTE pbCompany,
                                     PBYTE pbProduct,
                                     PBYTE pbVersion,
                                     PBYTE pbItem,
                                     PVOID pData,
                                     DWORD dSize);

BOOL WINAPI SbsSoftwareWriteBinaryW (PWORD pwFormat,
                                     PWORD pwCompany,
                                     PWORD pwProduct,
                                     PWORD pwVersion,
                                     PWORD pwItem,
                                     PVOID pData,
                                     DWORD dSize);

BOOL WINAPI SbsSoftwareDeleteKeyA (PBYTE pbFormat,
                                   PBYTE pbCompany,
                                   PBYTE pbProduct,
                                   PBYTE pbVersion,
                                   PBYTE pbItem);

BOOL WINAPI SbsSoftwareDeleteKeyW (PWORD pwFormat,
                                   PWORD pwCompany,
                                   PWORD pwProduct,
                                   PWORD pwVersion,
                                   PWORD pwItem);

BOOL WINAPI SbsSoftwareDeleteValueA (PBYTE pbFormat,
                                     PBYTE pbCompany,
                                     PBYTE pbProduct,
                                     PBYTE pbVersion,
                                     PBYTE pbItem);

BOOL WINAPI SbsSoftwareDeleteValueW (PWORD pwFormat,
                                     PWORD pwCompany,
                                     PWORD pwProduct,
                                     PWORD pwVersion,
                                     PWORD pwItem);

PVOID WINAPI SbsVersionRelease (PVOID pData);

QWORD WINAPI SbsVersionTokenA (PBYTE  pbVersion,
                               PDWORD pdOffset);

QWORD WINAPI SbsVersionTokenW (PWORD  pwVersion,
                               PDWORD pdOffset);

QWORD WINAPI SbsVersionBinaryA (PBYTE pbVersion,
                                BOOL  fFlushLeft);

QWORD WINAPI SbsVersionBinaryW (PWORD pwVersion,
                                BOOL  fFlushLeft);

PBYTE WINAPI SbsVersionTextA (QWORD qVersion);

PWORD WINAPI SbsVersionTextW (QWORD qVersion);

QWORD WINAPI SbsVersionFileA (PBYTE pbPath);

QWORD WINAPI SbsVersionFileW (PWORD pwPath);

PVS_VERSIONDATA WINAPI SbsVersionDataA (PBYTE pbPath,
                                        DWORD dIndex);

PVS_VERSIONDATA WINAPI SbsVersionDataW (PWORD pwPath,
                                        DWORD dIndex);

PVS_VERSIONINFO WINAPI SbsVersionInfoA (PBYTE  pbPath,
                                        PDWORD pdData);

PVS_VERSIONINFO WINAPI SbsVersionInfoW (PWORD  pwPath,
                                        PDWORD pdData);

DWORD WINAPI SbsVersionAlign (DWORD dSize);

BOOL WINAPI SbsVersionVerify (PVS_VERSIONINFO pvvi);

PVS_STRINGFILEINFO WINAPI SbsVersionStrings (PVS_VERSIONINFO pvvi);

PVS_VARFILEINFO WINAPI SbsVersionVars (PVS_VERSIONINFO pvvi);

PVS_TRANSLATION WINAPI SbsVersionTranslation (PVS_VERSIONINFO pvvi,
                                              PDWORD       pdCount);

PVS_STRINGTABLE WINAPI SbsVersionTableA (PVS_VERSIONINFO pvvi,
                                         PBYTE           pbTable);

PVS_STRINGTABLE WINAPI SbsVersionTableW (PVS_VERSIONINFO pvvi,
                                         PWORD           pwTable);

PVS_STRINGTABLE WINAPI SbsVersionTableEx (PVS_VERSIONINFO pvvi,
                                          DWORD           dIndex,
                                          PDWORD          pdCount);

PVS_STRING WINAPI SbsVersionTableStringA (PVS_STRINGTABLE pvst,
                                          PBYTE           pbName);

PVS_STRING WINAPI SbsVersionTableStringW (PVS_STRINGTABLE pvst,
                                          PWORD           pwName);

PVS_STRING WINAPI SbsVersionStringA (PVS_VERSIONINFO pvvi,
                                     PBYTE           pbName,
                                     PBYTE           pbTable);

PVS_STRING WINAPI SbsVersionStringW (PVS_VERSIONINFO pvvi,
                                     PWORD           pwName,
                                     PWORD           pwTable);

PVS_STRING WINAPI SbsVersionStringExA (PVS_VERSIONINFO pvvi,
                                       PBYTE           pbName,
                                       DWORD           dIndex,
                                       PDWORD          pdCount);

PVS_STRING WINAPI SbsVersionStringExW (PVS_VERSIONINFO pvvi,
                                       PWORD           pwName,
                                       DWORD           dIndex,
                                       PDWORD          pdCount);

PWORD WINAPI SbsVersionStringValue (PVS_STRING pvs,
                                    PDWORD     pdData);

DWORD WINAPI SbsVersionStringData (PVS_STRING pvs);

PBYTE WINAPI SbsVersionStringCopyA (PVS_STRING pvs);

PWORD WINAPI SbsVersionStringCopyW (PVS_STRING pvs);

PBYTE WINAPI SbsVersionLanguageA (DWORD  dId,
                                  PDWORD pdData);

PWORD WINAPI SbsVersionLanguageW (DWORD  dId,
                                  PDWORD pdData);

PBYTE WINAPI SbsVersionCodePageA (DWORD  dId,
                                  PDWORD pdData);

PWORD WINAPI SbsVersionCodePageW (DWORD  dId,
                                  PDWORD pdData);

PVS_VERSIONDATA WINAPI SbsVersionInfoDataA (PVS_VERSIONINFO pvvi,
                                            DWORD           dIndex);

PVS_VERSIONDATA WINAPI SbsVersionInfoDataW (PVS_VERSIONINFO pvvi,
                                            DWORD           dIndex);

INT WINAPI SbsVersionBoxA (HWND   hWnd,
                           UINT   uiType,
                           PBYTE  pbCaption,
                           PBYTE  pbPath,
                           DWORD  dIndex,
                           PDWORD pdCount);

INT WINAPI SbsVersionBoxW (HWND   hWnd,
                           UINT   uiType,
                           PWORD  pwCaption,
                           PWORD  pwPath,
                           DWORD  dIndex,
                           PDWORD pdCount);

BOOL WINAPI SbsBitmapInitialize (PSBS_BITMAP psb,
                                 DWORD       dRows,
                                 DWORD       dColumns,
                                 DWORD       dColors);

DWORD WINAPI SbsBitmapScan (PSBS_BITMAP psb,
                            DWORD       dColumns);

DWORD WINAPI SbsBitmapColors (DWORD dBitsPerPixel);

PVOID WINAPI SbsBitmapData (PSBS_BITMAP psb,
                            PDWORD      pdData);

PLOGPALETTE WINAPI SbsBitmapPaletteData (PSBS_BITMAP psb);

HPALETTE WINAPI SbsBitmapPaletteHandle (PSBS_BITMAP psb);

PSBS_BITMAP WINAPI SbsBitmapCreate (PBITMAPFILEHEADER pbfh,
                                    DWORD             dSize);

BOOL WINAPI SbsBitmapSaveA (PSBS_BITMAP psb,
                            PBYTE       pbPath);

BOOL WINAPI SbsBitmapSaveW (PSBS_BITMAP psb,
                            PWORD       pwPath);

PSBS_BITMAP WINAPI SbsBitmapLoadA (PBYTE pbPath);

PSBS_BITMAP WINAPI SbsBitmapLoadW (PWORD pwPath);

PSBS_BITMAP WINAPI SbsBitmapUnload (PSBS_BITMAP psb);

PSBS_BITMAP WINAPI SbsBitmapDefaultA (HINSTANCE hInstance,
                                      PBYTE     pbItem);

PSBS_BITMAP WINAPI SbsBitmapDefaultW (HINSTANCE hInstance,
                                      PWORD     pwItem);

BOOL WINAPI SbsBitmapDraw (PSBS_BITMAP psb,
                           HDC         hDC,
                           PRECT       pr);

BOOL WINAPI SbsBitmapRestore (PSBS_BITMAP psb,
                              HWND        hWnd);

BOOL WINAPI SbsBitmapStretch (PSBS_BITMAP psb,
                              HWND        hWnd,
                              DWORD       dFactor);

BOOL WINAPI SbsBitmapShrink (PSBS_BITMAP psb,
                             HWND        hWnd,
                             DWORD       dFactor);

BOOL WINAPI SbsUrlSpaceA (BYTE bData);

BOOL WINAPI SbsUrlSpaceW (WORD wData);

BOOL WINAPI SbsUrlEscapeA (BYTE bData);

BOOL WINAPI SbsUrlEscapeW (WORD wData);

DWORD WINAPI SbsUrlCountA (PBYTE pbData,
                           DWORD dData,
                           BOOL  fEncode);

DWORD WINAPI SbsUrlCountW (PWORD pwData,
                           DWORD dData,
                           BOOL  fEncode);

PBYTE WINAPI SbsUrlEncodeA (PBYTE  pbData,
                            PDWORD pdData);

PWORD WINAPI SbsUrlEncodeW (PWORD  pwData,
                            PDWORD pdData);

PBYTE WINAPI SbsUrlDecodeA (PBYTE  pbData,
                            PDWORD pdData);

PWORD WINAPI SbsUrlDecodeW (PWORD  pwData,
                            PDWORD pdData);

PSBS_URL WINAPI SbsUrlTrim (PSBS_URL psu);

PSBS_URL WINAPI SbsUrlFirstA (PBYTE pbPattern);

PSBS_URL WINAPI SbsUrlFirstW (PWORD pwPattern);

PSBS_URL WINAPI SbsUrlNext (PSBS_URL psu);

PSBS_URL WINAPI SbsUrlExit (PSBS_URL psu,
                            BOOL     fDestroy);

PSBS_URL WINAPI SbsCookieFindA (PBYTE pbDomain);

PSBS_URL WINAPI SbsCookieFindW (PWORD pwDomain);

PSBS_URL WINAPI SbsCookieFirstA (VOID);

PSBS_URL WINAPI SbsCookieFirstW (VOID);

PSBS_URL WINAPI SbsCookieNext (PSBS_URL psu);

PSBS_URL WINAPI SbsCookieExit (PSBS_URL psu,
                               BOOL     fDestroy);

BOOL WINAPI SbsCookieDeleteA (PBYTE pbDomain);

BOOL WINAPI SbsCookieDeleteW (PWORD pwDomain);

PBYTE WINAPI SbsCookieCreateA (PBYTE pbDomain);

PWORD WINAPI SbsCookieCreateW (PWORD pwDomain);

BOOL WINAPI SbsCookieCommitA (PBYTE    pbDomain,
                              PBYTE    pbPath,
                              FILETIME ftExpire,
                              FILETIME ftWrite);

BOOL WINAPI SbsCookieCommitW (PWORD    pwDomain,
                              PWORD    pwPath,
                              FILETIME ftExpire,
                              FILETIME ftWrite);

DWORD WINAPI SbsCookieTestA (PBYTE pbData,
                             DWORD dData);

DWORD WINAPI SbsCookieTestW (PWORD pwData,
                             DWORD dData);

DWORD WINAPI SbsCookieParseA (PBYTE             pbData,
                              DWORD             dData,
                              PSBS_COOKIE_VALUE pscv);

DWORD WINAPI SbsCookieParseW (PWORD             pwData,
                              DWORD             dData,
                              PSBS_COOKIE_VALUE pscv);

PSBS_COOKIE WINAPI SbsCookieCompileA (PBYTE     pbData,
                                      DWORD     dData,
                                      PFILETIME pftCreate,
                                      PFILETIME pftAccess,
                                      PFILETIME pftWrite);

PSBS_COOKIE WINAPI SbsCookieCompileW (PWORD     pwData,
                                      DWORD     dData,
                                      PFILETIME pftCreate,
                                      PFILETIME pftAccess,
                                      PFILETIME pftWrite);

PSBS_COOKIE WINAPI SbsCookieRelease (PSBS_COOKIE psc);

PSBS_COOKIE WINAPI SbsCookieLoadA (PBYTE pbPath);

PSBS_COOKIE WINAPI SbsCookieLoadW (PWORD pwPath);

BOOL WINAPI SbsCookieSaveA (PSBS_COOKIE psc,
                            PBYTE       pbPath);

BOOL WINAPI SbsCookieSaveW (PSBS_COOKIE psc,
                            PWORD       pwPath);

PSBS_COOKIE WINAPI SbsCookieAssignA (PBYTE     pbKey,
                                     PBYTE     pbValue,
                                     PBYTE     pbDomain,
                                     BOOL      fSecure,
                                     PFILETIME pftExpire,
                                     PFILETIME pftWrite);

PSBS_COOKIE WINAPI SbsCookieAssignW (PWORD     pwKey,
                                     PWORD     pwValue,
                                     PWORD     pwDomain,
                                     BOOL      fSecure,
                                     PFILETIME pftExpire,
                                     PFILETIME pftWrite);

PSBS_COOKIE WINAPI SbsCookieUpdateA (PSBS_COOKIE psc,
                                     PBYTE       pbKey,
                                     PBYTE       pbValue,
                                     PBYTE       pbDomain,
                                     BOOL        fSecure,
                                     PFILETIME   pftExpire,
                                     PFILETIME   pftWrite);

PSBS_COOKIE WINAPI SbsCookieUpdateW (PSBS_COOKIE psc,
                                     PWORD       pwKey,
                                     PWORD       pwValue,
                                     PWORD       pwDomain,
                                     BOOL        fSecure,
                                     PFILETIME   pftExpire,
                                     PFILETIME   pftWrite);

PSBS_COOKIE WINAPI SbsCookieRemoveA (PSBS_COOKIE psc,
                                     PBYTE       pbKey);

PSBS_COOKIE WINAPI SbsCookieRemoveW (PSBS_COOKIE psc,
                                     PWORD       pwKey);

PSBS_COOKIE WINAPI SbsCookieNewA (PBYTE     pbKey,
                                  PBYTE     pbValue,
                                  PBYTE     pbDomain,
                                  BOOL      fSecure,
                                  PFILETIME pftExpire);

PSBS_COOKIE WINAPI SbsCookieNewW (PWORD     pwKey,
                                  PWORD     pwValue,
                                  PWORD     pwDomain,
                                  BOOL      fSecure,
                                  PFILETIME pftExpire);

PSBS_COOKIE WINAPI SbsCookieAppendA (PSBS_COOKIE psc,
                                     PBYTE       pbKey,
                                     PBYTE       pbValue,
                                     PBYTE       pbDomain,
                                     BOOL        fSecure,
                                     PFILETIME   pftExpire);

PSBS_COOKIE WINAPI SbsCookieAppendW (PSBS_COOKIE psc,
                                     PWORD       pwKey,
                                     PWORD       pwValue,
                                     PWORD       pwDomain,
                                     BOOL        fSecure,
                                     PFILETIME   pftExpire);

PSBS_COOKIE WINAPI SbsCookieRebuildA (PSBS_COOKIE psc);

PSBS_COOKIE WINAPI SbsCookieRebuildW (PSBS_COOKIE psc);

PSBS_COOKIE WINAPI SbsCookieMergeA (DWORD dCookies,
                                    ...);

PSBS_COOKIE WINAPI SbsCookieMergeW (DWORD dCookies,
                                    ...);

BOOL WINAPI SbsCookieRegisterA (PSBS_COOKIE psc);

BOOL WINAPI SbsCookieRegisterW (PSBS_COOKIE psc);

BOOL WINAPI SbsCookieTime (PSBS_COOKIE psc,
                           PFILETIME   pftExpire,
                           PFILETIME   pftWrite);

PSBS_COOKIE_VALUE WINAPI SbsCookieValueA (PSBS_COOKIE psc,
                                          PBYTE       pbKey);

PSBS_COOKIE_VALUE WINAPI SbsCookieValueW (PSBS_COOKIE psc,
                                          PWORD       pwKey);

PBYTE WINAPI SbsCookieDataA (PSBS_COOKIE_VALUE pscv,
                             PDWORD            pdData);

PWORD WINAPI SbsCookieDataW (PSBS_COOKIE_VALUE pscv,
                             PDWORD            pdData);

PBYTE WINAPI SbsCookieDataW2A (PSBS_COOKIE_VALUE pscv,
                               PDWORD            pdData);

PBYTE WINAPI SbsCookieDataExA (PBYTE    pbKey,
                               PBYTE    pbValue,
                               PBYTE    pbDomain,
                               BOOL     fSecure,
                               FILETIME ftExpire,
                               FILETIME ftWrite,
                               PDWORD   pdData);

PWORD WINAPI SbsCookieDataExW (PWORD    pwKey,
                               PWORD    pwValue,
                               PWORD    pwDomain,
                               BOOL     fSecure,
                               FILETIME ftExpire,
                               FILETIME ftWrite,
                               PDWORD   pdData);

PBYTE WINAPI SbsCookieDataExW2A (PWORD    pwKey,
                                 PWORD    pwValue,
                                 PWORD    pwDomain,
                                 BOOL     fSecure,
                                 FILETIME ftExpire,
                                 FILETIME ftWrite,
                                 PDWORD   pdData);

PBYTE WINAPI SbsCookieUserA (VOID);

PWORD WINAPI SbsCookieUserW (VOID);

PBYTE WINAPI SbsCookieNameA (PBYTE pbDomain);

PWORD WINAPI SbsCookieNameW (PWORD pwDomain);

BOOL WINAPI SbsIniEscape (BYTE bData);

DWORD WINAPI SbsIniEncoded (PVOID pData,
                            DWORD dData);

PBYTE WINAPI SbsIniEncodeA (PVOID  pData,
                            PDWORD pdData);

PWORD WINAPI SbsIniEncodeW (PVOID  pData,
                            PDWORD pdData);

BOOL WINAPI SbsIniSpaceA (BYTE bData);

BOOL WINAPI SbsIniSpaceW (WORD wData);

DWORD WINAPI SbsIniDecodedA (PBYTE pbData,
                             DWORD dData);

DWORD WINAPI SbsIniDecodedW (PWORD pwData,
                             DWORD dData);

PVOID WINAPI SbsIniDecodeA (PBYTE  pbData,
                            PDWORD pdData);

PVOID WINAPI SbsIniDecodeW (PWORD  pwData,
                            PDWORD pdData);

PBYTE WINAPI SbsIniReadA (PBYTE  pbPath,
                          PBYTE  pbSection,
                          PBYTE  pbKey,
                          PDWORD pdData);

PWORD WINAPI SbsIniReadW (PWORD  pwPath,
                          PWORD  pwSection,
                          PWORD  pwKey,
                          PDWORD pdData);

PBYTE WINAPI SbsIniReadExA (PBYTE  pbPath,
                            PBYTE  pbSection,
                            PBYTE  pbKey,
                            PDWORD pdData,
                            BOOL   fCopy);

PWORD WINAPI SbsIniReadExW (PWORD  pwPath,
                            PWORD  pwSection,
                            PWORD  pwKey,
                            PDWORD pdData,
                            BOOL   fCopy);

PBYTE WINAPI SbsIniReadRawA (PBYTE  pbPath,
                             PBYTE  pbSection,
                             PBYTE  pbKey,
                             PDWORD pdData);

PWORD WINAPI SbsIniReadRawW (PWORD  pwPath,
                             PWORD  pwSection,
                             PWORD  pwKey,
                             PDWORD pdData);

PVOID WINAPI SbsIniReadCodeA (PBYTE  pbPath,
                              PBYTE  pbSection,
                              PBYTE  pbKey,
                              PDWORD pdData);

PVOID WINAPI SbsIniReadCodeW (PWORD  pwPath,
                              PWORD  pwSection,
                              PWORD  pwKey,
                              PDWORD pdData);

PVOID WINAPI SbsIniReadHexA (PBYTE  pbPath,
                             PBYTE  pbSection,
                             PBYTE  pbKey,
                             PDWORD pdData);

PVOID WINAPI SbsIniReadHexW (PWORD  pwPath,
                             PWORD  pwSection,
                             PWORD  pwKey,
                             PDWORD pdData);

PBYTE WINAPI SbsIniReadStringA (PBYTE  pbPath,
                                PBYTE  pbSection,
                                PBYTE  pbKey,
                                PDWORD pdData);

PWORD WINAPI SbsIniReadStringW (PWORD  pwPath,
                                PWORD  pwSection,
                                PWORD  pwKey,
                                PDWORD pdData);

DWORD WINAPI SbsIniReadStringExA (PBYTE pbPath,
                                  PBYTE pbSection,
                                  PBYTE pbKey,
                                  PBYTE pbBuffer,
                                  DWORD dBuffer);

DWORD WINAPI SbsIniReadStringExW (PWORD pwPath,
                                  PWORD pwSection,
                                  PWORD pwKey,
                                  PWORD pwBuffer,
                                  DWORD dBuffer);

DWORD WINAPI SbsIniReadDwordA (PBYTE pbPath,
                               PBYTE pbSection,
                               PBYTE pbKey,
                               DWORD dDefault);

DWORD WINAPI SbsIniReadDwordW (PWORD pwPath,
                               PWORD pwSection,
                               PWORD pwKey,
                               DWORD dDefault);

LONG WINAPI SbsIniReadLongA (PBYTE pbPath,
                             PBYTE pbSection,
                             PBYTE pbKey,
                             LONG  lDefault);

LONG WINAPI SbsIniReadLongW (PWORD pwPath,
                             PWORD pwSection,
                             PWORD pwKey,
                             LONG  lDefault);

BOOL WINAPI SbsIniReadBoolA (PBYTE pbPath,
                             PBYTE pbSection,
                             PBYTE pbKey,
                             BOOL  fDefault);

BOOL WINAPI SbsIniReadBoolW (PWORD pwPath,
                             PWORD pwSection,
                             PWORD pwKey,
                             BOOL  fDefault);

COLORREF WINAPI SbsIniReadColorA (PBYTE    pbPath,
                                  PBYTE    pbSection,
                                  PBYTE    pbKey,
                                  COLORREF crDefault);

COLORREF WINAPI SbsIniReadColorW (PWORD    pwPath,
                                  PWORD    pwSection,
                                  PWORD    pwKey,
                                  COLORREF crDefault);

PLOGFONTA WINAPI SbsIniReadFontA (PBYTE     pbPath,
                                  PBYTE     pbSection,
                                  PBYTE     pbKey,
                                  PLOGFONTA plfDefaultA);

PLOGFONTW WINAPI SbsIniReadFontW (PWORD     pwPath,
                                  PWORD     pwSection,
                                  PWORD     pwKey,
                                  PLOGFONTW plfDefaultW);

BOOL WINAPI SbsIniReadFontExA (PBYTE     pbPath,
                               PBYTE     pbSection,
                               PBYTE     pbKey,
                               PLOGFONTA plfBufferA);

BOOL WINAPI SbsIniReadFontExW (PWORD     pwPath,
                               PWORD     pwSection,
                               PWORD     pwKey,
                               PLOGFONTW plfBufferW);

BOOL WINAPI SbsIniReadDataA (PBYTE pbPath,
                             PBYTE pbSection,
                             PBYTE pbKey,
                             PVOID pData,
                             DWORD dType);

BOOL WINAPI SbsIniReadDataW (PWORD pwPath,
                             PWORD pwSection,
                             PWORD pwKey,
                             PVOID pData,
                             DWORD dType);

BOOL WINAPI SbsIniWriteA (PBYTE pbPath,
                          PBYTE pbSection,
                          PBYTE pbKey,
                          PBYTE pbData);

BOOL WINAPI SbsIniWriteW (PWORD pwPath,
                          PWORD pwSection,
                          PWORD pwKey,
                          PWORD pwData);

BOOL WINAPI SbsIniWriteExA (PBYTE pbPath,
                            PBYTE pbSection,
                            PBYTE pbKey,
                            PBYTE pbData);

BOOL WINAPI SbsIniWriteExW (PWORD pwPath,
                            PWORD pwSection,
                            PWORD pwKey,
                            PWORD pwData);

BOOL WINAPI SbsIniWriteRawA (PBYTE pbPath,
                             PBYTE pbSection,
                             PBYTE pbKey,
                             PBYTE pbData);

BOOL WINAPI SbsIniWriteRawW (PWORD pwPath,
                             PWORD pwSection,
                             PWORD pwKey,
                             PWORD pwData);

BOOL WINAPI SbsIniWriteCodeA (PBYTE pbPath,
                              PBYTE pbSection,
                              PBYTE pbKey,
                              PVOID pData,
                              DWORD dData);

BOOL WINAPI SbsIniWriteCodeW (PWORD pwPath,
                              PWORD pwSection,
                              PWORD pwKey,
                              PVOID pData,
                              DWORD dData);

BOOL WINAPI SbsIniWriteHexA (PBYTE pbPath,
                             PBYTE pbSection,
                             PBYTE pbKey,
                             PVOID pData,
                             DWORD dData);

BOOL WINAPI SbsIniWriteHexW (PWORD pwPath,
                             PWORD pwSection,
                             PWORD pwKey,
                             PVOID pData,
                             DWORD dData);

BOOL WINAPI SbsIniWriteStringA (PBYTE pbPath,
                                PBYTE pbSection,
                                PBYTE pbKey,
                                PBYTE pbData);

BOOL WINAPI SbsIniWriteStringW (PWORD pwPath,
                                PWORD pwSection,
                                PWORD pwKey,
                                PWORD pwData);

BOOL WINAPI SbsIniWriteDwordA (PBYTE  pbPath,
                               PBYTE  pbSection,
                               PBYTE  pbKey,
                               PDWORD pdData);

BOOL WINAPI SbsIniWriteDwordW (PWORD  pwPath,
                               PWORD  pwSection,
                               PWORD  pwKey,
                               PDWORD pdData);

BOOL WINAPI SbsIniWriteLongA (PBYTE pbPath,
                              PBYTE pbSection,
                              PBYTE pbKey,
                              PLONG plData);

BOOL WINAPI SbsIniWriteLongW (PWORD pwPath,
                              PWORD pwSection,
                              PWORD pwKey,
                              PLONG plData);

BOOL WINAPI SbsIniWriteBoolA (PBYTE pbPath,
                              PBYTE pbSection,
                              PBYTE pbKey,
                              PBOOL pfData);

BOOL WINAPI SbsIniWriteBoolW (PWORD pwPath,
                              PWORD pwSection,
                              PWORD pwKey,
                              PBOOL pfData);

BOOL WINAPI SbsIniWriteColorA (PBYTE     pbPath,
                               PBYTE     pbSection,
                               PBYTE     pbKey,
                               PCOLORREF pcr);

BOOL WINAPI SbsIniWriteColorW (PWORD     pwPath,
                               PWORD     pwSection,
                               PWORD     pwKey,
                               PCOLORREF pcr);

BOOL WINAPI SbsIniWriteFontA (PBYTE     pbPath,
                              PBYTE     pbSection,
                              PBYTE     pbKey,
                              PLOGFONTA plfA);

BOOL WINAPI SbsIniWriteFontW (PWORD     pwPath,
                              PWORD     pwSection,
                              PWORD     pwKey,
                              PLOGFONTW plfW);

BOOL WINAPI SbsIniWriteDataA (PBYTE pbPath,
                              PBYTE pbSection,
                              PBYTE pbKey,
                              PVOID pData,
                              DWORD dType);

BOOL WINAPI SbsIniWriteDataW (PWORD pwPath,
                              PWORD pwSection,
                              PWORD pwKey,
                              PVOID pData,
                              DWORD dType);

BOOL WINAPI SbsIniDeleteKeyA (PBYTE pbPath,
                              PBYTE pbSection,
                              PBYTE pbKey,
                              BOOL  fLocal);

BOOL WINAPI SbsIniDeleteKeyW (PWORD pwPath,
                              PWORD pwSection,
                              PWORD pwKey,
                              BOOL  fLocal);

BOOL WINAPI SbsIniDeleteKeysA (PBYTE pbPath,
                               PBYTE pbKey,
                               BOOL  fLocal);

BOOL WINAPI SbsIniDeleteKeysW (PWORD pwPath,
                               PWORD pwKey,
                               BOOL  fLocal);

BOOL WINAPI SbsIniDeleteSectionA (PBYTE pbPath,
                                  PBYTE pbSection,
                                  BOOL  fLocal);

BOOL WINAPI SbsIniDeleteSectionW (PWORD pwPath,
                                  PWORD pwSection,
                                  BOOL  fLocal);

BOOL WINAPI SbsIniDeleteAllA (PBYTE pbPath,
                              BOOL  fLocal);

BOOL WINAPI SbsIniDeleteAllW (PWORD pwPath,
                              BOOL  fLocal);

HANDLE WINAPI SbsProcessRunA (PBYTE  pbCommand,
                              DWORD  dFlags,
                              DWORD  dTimeout,
                              PDWORD pdExitCode);

HANDLE WINAPI SbsProcessRunW (PWORD  pwCommand,
                              DWORD  dFlags,
                              DWORD  dTimeout,
                              PDWORD pdExitCode);

PSBS_THREAD WINAPI SbsThreadOpenA (HWND        hOwner,
                                   DWORD       dTime,
                                   SBS_HANDLER Handler,
                                   PVOID       pContext,
                                   HICON       hIcon);

PSBS_THREAD WINAPI SbsThreadOpenW (HWND        hOwner,
                                   DWORD       dTime,
                                   SBS_HANDLER Handler,
                                   PVOID       pContext,
                                   HICON       hIcon);

PSBS_THREAD WINAPI SbsThreadOpenEx (HWND        hOwner,
                                    DWORD       dTime,
                                    SBS_HANDLER Handler,
                                    PVOID       pContext,
                                    HICON       hIcon,
                                    HBITMAP     hBitmap,
                                    DWORD       dWidth,
                                    DWORD       dHeight,
                                    BOOL        fUnicode);

PSBS_THREAD WINAPI SbsThreadClose (PSBS_THREAD pst);

LRESULT WINAPI SbsThreadSend (PSBS_THREAD pst,
                              UINT        uiMsg,
                              WPARAM      wParam,
                              LPARAM      lParam);

BOOL WINAPI SbsThreadPost (PSBS_THREAD pst,
                           UINT        uiMsg,
                           WPARAM      wParam,
                           LPARAM      lParam);

BOOL WINAPI SbsThreadPeek (PSBS_THREAD pst,
                           PMSG        pMsg,
                           UINT        uiFilterMin,
                           UINT        uiFilterMax,
                           UINT        uiRemove);

LRESULT WINAPI SbsThreadGet (PSBS_THREAD pst,
                             PMSG        pMsg,
                             UINT        uiFilterMin,
                             UINT        uiFilterMax);

LRESULT WINAPI SbsThreadDispatch (PSBS_THREAD pst,
                                  PMSG        pMsg);

DWORD WINAPI SbsThreadHandler (PSBS_THREAD pst);

BOOL WINAPI SbsThreadSpy (PSBS_THREAD pst,
                          DWORD       dTimeout,
                          SBS_SPY     Spy,
                          PVOID       pContext);

BOOL WINAPI SbsThreadLock (PSBS_THREAD pst);

VOID WINAPI SbsThreadUnlock (PSBS_THREAD pst);

BOOL WINAPI SbsThreadAttach (PSBS_THREAD pst);

BOOL WINAPI SbsThreadDetach (PSBS_THREAD pst);

BOOL WINAPI SbsThreadTrace (PSBS_THREAD pst,
                            HICON       hIcon,
                            PVOID       pInfo,
                            DWORD       dDelay);

BOOL WINAPI SbsThreadDraw (PSBS_THREAD pst,
                           HDC         hDC);

BOOL WINAPI SbsThreadUpdateA (PSBS_THREAD pst,
                              HICON       hIcon,
                              PBYTE       pbInfo);

BOOL WINAPI SbsThreadUpdateW (PSBS_THREAD pst,
                              HICON       hIcon,
                              PWORD       pwInfo);

LRESULT WINAPI SbsThreadInfo (PSBS_THREAD pst,
                              HICON       hIcon,
                              PVOID       pInfo);

LRESULT WINAPI SbsThreadIdle (PSBS_THREAD pst);

LRESULT WINAPI SbsThreadCommand (PSBS_THREAD pst,
                                 DWORD       dCommand,
                                 PVOID       pCommand);

LRESULT WINAPI SbsThreadNotify (PSBS_THREAD pst,
                                DWORD       dCommand,
                                PVOID       pCommand);

LRESULT CALLBACK SbsThreadWindow (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam);

LRESULT WINAPI SbsThreadWindowStartup (HWND        hWnd,
                                       UINT        uiMsg,
                                       WPARAM      wParam,
                                       LPARAM      lParam,
                                       PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowCleanup (HWND        hWnd,
                                       UINT        uiMsg,
                                       WPARAM      wParam,
                                       LPARAM      lParam,
                                       PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowInfo (HWND        hWnd,
                                    UINT        uiMsg,
                                    WPARAM      wParam,
                                    LPARAM      lParam,
                                    PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowIdle (HWND        hWnd,
                                    UINT        uiMsg,
                                    WPARAM      wParam,
                                    LPARAM      lParam,
                                    PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowCommand (HWND        hWnd,
                                       UINT        uiMsg,
                                       WPARAM      wParam,
                                       LPARAM      lParam,
                                       PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowMessage (HWND        hWnd,
                                       UINT        uiMsg,
                                       WPARAM      wParam,
                                       LPARAM      lParam,
                                       PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowPaint (HWND        hWnd,
                                     UINT        uiMsg,
                                     WPARAM      wParam,
                                     LPARAM      lParam,
                                     PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowDestroy (HWND        hWnd,
                                       UINT        uiMsg,
                                       WPARAM      wParam,
                                       LPARAM      lParam,
                                       PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowTimer (HWND        hWnd,
                                     UINT        uiMsg,
                                     WPARAM      wParam,
                                     LPARAM      lParam,
                                     PSBS_THREAD pst);

LRESULT WINAPI SbsThreadWindowCopyData (HWND        hWnd,
                                        UINT        uiMsg,
                                        WPARAM      wParam,
                                        LPARAM      lParam,
                                        PSBS_THREAD pst);

BOOL WINAPI SbsWindowValid (HWND hWnd);

LONG WINAPI SbsWindowLongRead (HWND hWnd,
                               INT  iIndex);

LONG WINAPI SbsWindowLongWrite (HWND hWnd,
                                INT  iIndex,
                                LONG lData);

PVOID WINAPI SbsWindowUserRead (HWND hWnd);

PVOID WINAPI SbsWindowUserWrite (HWND  hWnd,
                                 PVOID pUser);

WNDPROC WINAPI SbsWindowProcedure (HWND hWnd);

DWORD WINAPI SbsWindowStyle (HWND hWnd);

LRESULT WINAPI SbsWindowCall (WNDPROC wp,
                              HWND    hWnd,
                              UINT    uiMsg,
                              WPARAM  wParam,
                              LPARAM  lParam,
                              LRESULT lrError);

LRESULT WINAPI SbsWindowDefault (HWND    hWnd,
                                 UINT    uiMsg,
                                 WPARAM  wParam,
                                 LPARAM  lParam,
                                 LRESULT lrError);

LRESULT WINAPI SbsWindowSend (HWND    hWnd,
                              UINT    uiMsg,
                              WPARAM  wParam,
                              LPARAM  lParam,
                              LRESULT lrError);

BOOL WINAPI SbsWindowPost (HWND   hWnd,
                           UINT   uiMsg,
                           WPARAM wParam,
                           LPARAM lParam);

BOOL WINAPI SbsWindowRectangle (HWND   hWnd,
                                PRECT  pr,
                                PDWORD pdMode);

BOOL WINAPI SbsWindowDesktop (PRECT pr);

VOID WINAPI SbsWindowClipRectangle (PRECT pr);

VOID WINAPI SbsWindowClipPosition (PDWORD pdColumn,
                                   PDWORD pdRow,
                                   PDWORD pdWidth,
                                   PDWORD pdHeight);

BOOL WINAPI SbsWindowMove (HWND  hWnd,
                           PRECT pr,
                           DWORD dMode);

BOOL WINAPI SbsWindowMoveEx (HWND   hWnd,
                             DWORD  dMode,
                             PDWORD pdColumn,
                             PDWORD pdRow,
                             PDWORD pdWidth,
                             PDWORD pdHeight);

BOOL WINAPI SbsWindowRecord (HWND hWnd);

BOOL WINAPI SbsWindowZoom (HWND  hWnd,
                           DWORD dWidth,
                           DWORD dHeight,
                           BOOL  fClient);

BOOL WINAPI SbsWindowRestore (HWND  hWnd,
                              DWORD dMode);

BOOL WINAPI SbsWindowCenter (HWND  hWnd,
                             DWORD dMode);

DWORD WINAPI SbsWindowCenterColumn (PDWORD pdWidth);

DWORD WINAPI SbsWindowCenterRow (PDWORD pdHeight);

VOID WINAPI SbsWindowSave (HWND hWnd);

PSBS_WINDOW WINAPI SbsWindowNewA (HWND    hWndParent,
                                  WNDPROC WndProc,
                                  PBYTE   pbWindow,
                                  PBYTE   pbCaption,
                                  PBYTE   pbClass,
                                  PBYTE   pbIcon,
                                  PBYTE   pbMenu,
                                  PVOID   pContext);

PSBS_WINDOW WINAPI SbsWindowNewW (HWND    hWndParent,
                                  WNDPROC WndProc,
                                  PWORD   pwWindow,
                                  PWORD   pwCaption,
                                  PWORD   pwClass,
                                  PWORD   pwIcon,
                                  PWORD   pwMenu,
                                  PVOID   pContext);

HWND WINAPI SbsWindowCreateA (HWND    hWndParent,
                              WNDPROC WndProc,
                              PBYTE   pbWindow,
                              PBYTE   pbCaption,
                              PBYTE   pbClass,
                              PBYTE   pbIcon,
                              PBYTE   pbMenu,
                              PVOID   pContext,
                              DWORD   dStatus,
                              PDWORD  pdStatus);

HWND WINAPI SbsWindowCreateW (HWND    hWndParent,
                              WNDPROC WndProc,
                              PWORD   pwWindow,
                              PWORD   pwCaption,
                              PWORD   pwClass,
                              PWORD   pwIcon,
                              PWORD   pwMenu,
                              PVOID   pContext,
                              DWORD   dStatus,
                              PDWORD  pdStatus);

BOOL WINAPI SbsWindowDestroy (HWND hWnd);

INT WINAPI SbsWindowMainA (WNDPROC WndProc,
                           PBYTE   pbWindow,
                           PBYTE   pbCaption,
                           PBYTE   pbClass,
                           PBYTE   pbIcon,
                           PBYTE   pbMenu,
                           PVOID   pContext,
                           DWORD   dMode,
                           UINT    uiMsg,
                           WPARAM  wParam,
                           LPARAM  lParam);

INT WINAPI SbsWindowMainW (WNDPROC WndProc,
                           PWORD   pwWindow,
                           PWORD   pwCaption,
                           PWORD   pwClass,
                           PWORD   pwIcon,
                           PWORD   pwMenu,
                           PVOID   pContext,
                           DWORD   dMode,
                           UINT    uiMsg,
                           WPARAM  wParam,
                           LPARAM  lParam);

BOOL WINAPI SbsWindowIdleA (HWND hWnd);

BOOL WINAPI SbsWindowIdleW (HWND hWnd);

LRESULT WINAPI SbsWindowDispatch (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam,
                                  PVOID  pUser,
                                  DWORD  dEvent,
                                  ...);

LRESULT WINAPI SbsWindowDispatchEx (HWND   hWnd,
                                    UINT   uiMsg,
                                    WPARAM wParam,
                                    LPARAM lParam,
                                    DWORD  dEvent,
                                    ...);

WNDPROC WINAPI SbsWindowSubclass (HWND    hWnd,
                                  WNDPROC wpNew,
                                  PVOID   pUser);

LRESULT WINAPI SbsWindowNotify (HWND hWnd,
                                INT  iMenu,
                                HWND hActive);

DWORD WINAPI SbsWindowRecurse (HWND  hWnd,
                               DWORD dMode);

BOOL WINAPI SbsWindowUpdate (HWND hWnd);

BOOL WINAPI SbsWindowSelect (HWND hWnd);

BOOL WINAPI SbsWindowActivate (HWND hWnd);

INT WINAPI SbsWindowControl (LPARAM wParam,
                             LPARAM lParam);

INT WINAPI SbsWindowControlEx (LPARAM wParam,
                               LPARAM lParam,
                               PHWND  phItem,
                               PDWORD pdCode);

DWORD WINAPI SbsWindowControlCode (LPARAM wParam,
                                   LPARAM lParam);

HWND WINAPI SbsWindowControlHandle (LPARAM wParam,
                                    LPARAM lParam);

BOOL WINAPI SbsWindowMenuSet (HWND  hWnd,
                              HMENU hMenu);

DWORD WINAPI SbsWindowLabelA (PBYTE pbBuffer);

DWORD WINAPI SbsWindowLabelW (PWORD pwBuffer);

DWORD WINAPI SbsWindowMenuReadA (HWND  hWnd,
                                 DWORD dItem,
                                 PBYTE pbBuffer,
                                 DWORD dBuffer);

DWORD WINAPI SbsWindowMenuReadW (HWND  hWnd,
                                 DWORD dItem,
                                 PWORD pwBuffer,
                                 DWORD dBuffer);

PSBS_WINDOW WINAPI SbsWindowFontA (HWND      hWnd,
                                   PLOGFONTA plfA,
                                   PCOLORREF pcrColor,
                                   PCOLORREF pcrBrush);

PSBS_WINDOW WINAPI SbsWindowFontW (HWND      hWnd,
                                   PLOGFONTW plfW,
                                   PCOLORREF pcrColor,
                                   PCOLORREF pcrBrush);

INT WINAPI SbsWindowDrawText (HWND  hWnd,
                              HDC   hDC,
                              PRECT pr,
                              PVOID pText,
                              DWORD dText,
                              DWORD dFormat);

BOOL WINAPI SbsWindowDataRead (HWND  hWnd,
                               PVOID pKey,
                               PVOID pData,
                               DWORD dType);

BOOL WINAPI SbsWindowDataReadEx (HWND hWnd,
                                 ...);

BOOL WINAPI SbsWindowDataWrite (HWND  hWnd,
                                PVOID pKey,
                                PVOID pData,
                                DWORD dType);

BOOL WINAPI SbsWindowDataWriteEx (HWND hWnd,
                                  ...);

LRESULT WINAPI SbsDialogResult (HWND    hWnd,
                                UINT    uiMsg,
                                LRESULT lr);

LRESULT WINAPI SbsDialogHandler (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser,
                                 PROC   Handler);

LRESULT WINAPI SbsDialogDispatch (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam,
                                  PVOID  pUser,
                                  DWORD  dEvent,
                                  ...);

LRESULT WINAPI SbsDialogDispatchEx (HWND   hWnd,
                                    UINT   uiMsg,
                                    WPARAM wParam,
                                    LPARAM lParam,
                                    DWORD  dEvent,
                                    ...);

INT WINAPI SbsDialogFocus (HWND hWnd);

WNDPROC WINAPI SbsDialogSubclass (HWND    hWnd,
                                  INT     iItem,
                                  WNDPROC wpNew,
                                  PVOID   pUser);

LRESULT WINAPI SbsDialogNotify (HWND  hWnd,
                                INT   iItem,
                                DWORD dCode);

LRESULT WINAPI SbsDialogSelect (HWND hWnd,
                                INT  iItem);

LRESULT WINAPI SbsDialogSkip (HWND hWnd,
                              BOOL fBack);

BOOL WINAPI SbsDialogChecked (HWND hWnd,
                              INT  iItem);

BOOL WINAPI SbsDialogCheck (HWND hWnd,
                            INT  iItem,
                            BOOL fChecked);

BOOL WINAPI SbsDialogToggle (HWND hWnd,
                             INT  iItem);

BOOL WINAPI SbsDialogEnable (HWND hWnd,
                             INT  iItem,
                             BOOL fEnable);

BOOL WINAPI SbsDialogEnabled (HWND hWnd,
                              INT  iItem);

BOOL WINAPI SbsDialogShow (HWND hWnd,
                           INT  iItem,
                           BOOL fShow);

BOOL WINAPI SbsDialogSwitch (HWND hWnd,
                             INT  iHide,
                             INT  iShow);

BOOL WINAPI SbsDialogRedraw (HWND hWnd,
                             INT  iItem,
                             BOOL fErase,
                             BOOL fUpdate);

HFONT WINAPI SbsDialogFont (HWND  hWnd,
                            INT   iItem,
                            HFONT hFont);

HFONT WINAPI SbsDialogFontEx (HWND  hWnd,
                              INT   iItem,
                              HFONT hFont,
                              PRECT prClient);

BOOL WINAPI SbsDialogRectangle (HWND  hWnd,
                                INT   iItem,
                                PRECT pr);

BOOL WINAPI SbsDialogMove (HWND  hWnd,
                           INT   iItem,
                           PRECT pr);

BOOL WINAPI SbsDialogZoom (HWND  hWnd,
                           INT   iItem,
                           PRECT prItem,
                           PRECT prClient);

PSBS_DIALOG WINAPI SbsDialogZoomOpen (HWND  hWnd,
                                      HFONT hFont1,
                                      HFONT hFont2,
                                      HFONT hFont3,
                                      HFONT hFont4,
                                      ...);

PSBS_DIALOG WINAPI SbsDialogZoomClose (PSBS_DIALOG psd);

BOOL WINAPI SbsDialogZoomUpdate (PSBS_DIALOG psd);

PBYTE WINAPI SbsDialogReadA (HWND hWnd,
                             INT  iItem,
                             BOOL fTrim);

PWORD WINAPI SbsDialogReadW (HWND hWnd,
                             INT  iItem,
                             BOOL fTrim);

PVOID WINAPI SbsDialogReadEx (HWND hWnd,
                              INT  iItem,
                              BOOL fTrim);

BOOL WINAPI SbsDialogWriteA (HWND  hWnd,
                             INT   iItem,
                             PBYTE pbText,
                             PBYTE pbDefault);

BOOL WINAPI SbsDialogWriteW (HWND  hWnd,
                             INT   iItem,
                             PWORD pwText,
                             PWORD pwDefault);

BOOL WINAPI SbsDialogWriteEx (HWND  hWnd,
                              INT   iItem,
                              PVOID pText,
                              PVOID pDefault);

BOOL WINAPI SbsDialogWriteText (HWND      hWnd,
                                INT       iItem,
                                PSBS_TEXT pstText,
                                PSBS_TEXT pstDefault);

BOOL WINAPI SbsDialogClear (HWND hWnd,
                            INT  iItem);

BOOL WINAPI SbsDialogTest (HWND hWnd,
                           INT  iItem,
                           BOOL fTrim);

PBYTE WINAPI SbsDialogLabelA (HWND hWnd,
                              INT  iItem);

PWORD WINAPI SbsDialogLabelW (HWND hWnd,
                              INT  iItem);

PVOID WINAPI SbsDialogLabelEx (HWND hWnd,
                               INT  iItem);

BOOL WINAPI SbsDialogCopyA (HWND  hWnd,
                            INT   iFrom,
                            INT   iTo,
                            BOOL  fTrim,
                            PBYTE pbError);

BOOL WINAPI SbsDialogCopyW (HWND  hWnd,
                            INT   iFrom,
                            INT   iTo,
                            BOOL  fTrim,
                            PWORD pwError);

BOOL WINAPI SbsDialogCopyEx (HWND  hWnd,
                             INT   iFrom,
                             INT   iTo,
                             BOOL  fTrim,
                             PVOID pError);

BOOL WINAPI SbsDialogTime (HWND        hWnd,
                           INT         iItem,
                           PSYSTEMTIME pst,
                           BOOL        fGerman);

BOOL WINAPI SbsDialogTimeUtc (HWND      hWnd,
                              INT       iItem,
                              PFILETIME pft,
                              BOOL      fGerman);

BOOL WINAPI SbsDialogTimeLocal (HWND      hWnd,
                                INT       iItem,
                                PFILETIME pft,
                                BOOL      fGerman);

PSBS_LIST WINAPI SbsListCreate (HWND hWnd,
                                INT  iItem,
                                BOOL fCombo);

PSBS_LIST WINAPI SbsListCreateEx (HWND    hWnd,
                                  INT     iItem,
                                  BOOL    fCombo,
                                  BOOL    fClear,
                                  HCURSOR hCursor);

PSBS_LIST WINAPI SbsListDestroy (PSBS_LIST psl);

BOOL WINAPI SbsListOpen (PSBS_LIST psl,
                         BOOL      fClear);

DWORD WINAPI SbsListClose (PSBS_LIST psl,
                           DWORD     dIndex);

DWORD WINAPI SbsListCloseEx (PSBS_LIST psl,
                             DWORD     dIndex,
                             BOOL      fNotify);

PSBS_LIST WINAPI SbsListNew (HWND        hWnd,
                             INT         iItem,
                             BOOL        fCombo,
                             DWORD       dIndex,
                             SBS_LISTNEW Callback,
                             PVOID       pContext,
                             PDWORD      pdCount);

BOOL WINAPI SbsListClear (PSBS_LIST psl);

BOOL WINAPI SbsListUpdate (PSBS_LIST psl,
                           BOOL      fRedraw);

DWORD WINAPI SbsListInsert (PSBS_LIST psl,
                            PVOID     pText,
                            DWORD     dData,
                            DWORD     dIndex);

DWORD WINAPI SbsListAdd (PSBS_LIST psl,
                         PVOID     pText,
                         DWORD     dData);

DWORD WINAPI SbsListRemove (PSBS_LIST psl,
                            DWORD     dIndex);

DWORD WINAPI SbsListCount (PSBS_LIST psl);

DWORD WINAPI SbsListItem (PSBS_LIST psl,
                          DWORD     dIndex,
                          DWORD     dDefault);

DWORD WINAPI SbsListIndex (PSBS_LIST psl);

BOOL WINAPI SbsListEnd (PSBS_LIST psl);

DWORD WINAPI SbsListSelect (PSBS_LIST psl,
                            DWORD     dIndex);

DWORD WINAPI SbsListSelectEx (PSBS_LIST psl,
                              DWORD     dIndex,
                              BOOL      fNotify);

DWORD WINAPI SbsListSelectText (PSBS_LIST psl,
                                PVOID     pText,
                                DWORD     dDefault);

DWORD WINAPI SbsListSkip (PSBS_LIST psl,
                          DWORD     dDelta,
                          BOOL      fDown);

DWORD WINAPI SbsListUp (PSBS_LIST psl);

DWORD WINAPI SbsListDown (PSBS_LIST psl);

BOOL WINAPI SbsListNotify (PSBS_LIST       psl,
                           SBS_LIST_NOTIFY Notify);

BOOL WINAPI SbsListSelChange (PSBS_LIST psl);

BOOL WINAPI SbsListDoubleClick (PSBS_LIST psl);

DWORD WINAPI SbsListSize (PSBS_LIST psl);

PVOID WINAPI SbsListText (PSBS_LIST psl,
                          DWORD     dIndex);

BOOL WINAPI SbsListData (PSBS_LIST psl,
                         DWORD     dIndex,
                         PDWORD    pdData);

DWORD WINAPI SbsListFind (PSBS_LIST psl,
                          DWORD     dIndex,
                          PVOID     pText,
                          PDWORD    pdData);

DWORD WINAPI SbsListSend (PSBS_LIST        psl,
                          SBS_LIST_MESSAGE Message,
                          WPARAM           wParam,
                          LPARAM           lParam);

INT WINAPI SbsAboutBoxA (HWND  hWnd,
                         HICON hIcon,
                         PBYTE pbCaption,
                         PBYTE pbText1,
                         PBYTE pbText2,
                         PBYTE pbText3,
                         PBYTE pbText4);

INT WINAPI SbsAboutBoxW (HWND  hWnd,
                         HICON hIcon,
                         PWORD pwCaption,
                         PWORD pwText1,
                         PWORD pwText2,
                         PWORD pwText3,
                         PWORD pwText4);

LRESULT WINAPI SbsAboutIconProc1 (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam);

LRESULT WINAPI SbsAboutIconProc2 (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam);

LRESULT WINAPI SbsAboutDlgInitDialog (HWND       hWnd,
                                      UINT       uiMsg,
                                      WPARAM     wParam,
                                      LPARAM     lParam,
                                      PSBS_ABOUT psa);

LRESULT WINAPI SbsAboutCmdOk (HWND       hWnd,
                              UINT       uiMsg,
                              WPARAM     wParam,
                              LPARAM     lParam,
                              PSBS_ABOUT psa);

LRESULT WINAPI SbsAboutCmdCancel (HWND       hWnd,
                                  UINT       uiMsg,
                                  WPARAM     wParam,
                                  LPARAM     lParam,
                                  PSBS_ABOUT psa);

LRESULT WINAPI SbsAboutDlgCommand (HWND       hWnd,
                                   UINT       uiMsg,
                                   WPARAM     wParam,
                                   LPARAM     lParam,
                                   PSBS_ABOUT psa);

LRESULT CALLBACK SbsAboutDlgProc (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam);

HWND WINAPI SbsStatusCreateA (HWND   hWnd,
                              DWORD  dId,
                              DWORD  dParts,
                              PDWORD pdWidths);

HWND WINAPI SbsStatusCreateW (HWND   hWnd,
                              DWORD  dId,
                              DWORD  dParts,
                              PDWORD pdWidths);

BOOL WINAPI SbsStatusMove (HWND  hWnd,
                           DWORD dWidth,
                           DWORD dHeight);

BOOL WINAPI SbsStatusUpdateA (HWND  hWnd,
                              DWORD dPart,
                              DWORD dType,
                              PBYTE pbFormat,
                              ...);

BOOL WINAPI SbsStatusUpdateW (HWND  hWnd,
                              DWORD dPart,
                              DWORD dType,
                              PWORD pwFormat,
                              ...);

DWORD WINAPI SbsStatusWidth (HWND hWnd);

DWORD WINAPI SbsStatusHeight (HWND hWnd);

VOID WINAPI SbsSelectFontA (HWND hWnd,
                            BOOL fFixed);

VOID WINAPI SbsSelectFontW (HWND hWnd,
                            BOOL fFixed);

VOID WINAPI SbsSelectBrushA (HWND hWnd);

VOID WINAPI SbsSelectBrushW (HWND hWnd);

PPBYTE WINAPI SbsSelectFilesA (HWND   hWnd,
                               PBYTE  pbCaption,
                               PBYTE  pbFilter,
                               PBYTE  pbPreset,
                               BOOL   fSave,
                               PDWORD pdCount);

PPWORD WINAPI SbsSelectFilesW (HWND   hWnd,
                               PWORD  pwCaption,
                               PWORD  pwFilter,
                               PWORD  pwPreset,
                               BOOL   fSave,
                               PDWORD pdCount);

PBYTE WINAPI SbsSelectFileA (HWND  hWnd,
                             PBYTE pbCaption,
                             PBYTE pbFilter,
                             PBYTE pbPreset,
                             BOOL  fSave);

PWORD WINAPI SbsSelectFileW (HWND  hWnd,
                             PWORD pwCaption,
                             PWORD pwFilter,
                             PWORD pwPreset,
                             BOOL  fSave);

LRESULT WINAPI SbsWmClose (HWND   hWnd,
                           UINT   uiMsg,
                           WPARAM wParam,
                           LPARAM lParam,
                           PVOID  pUser);

LRESULT WINAPI SbsWmDestroy (HWND   hWnd,
                             UINT   uiMsg,
                             WPARAM wParam,
                             LPARAM lParam,
                             PVOID  pUser);

LRESULT WINAPI SbsWmSize (HWND   hWnd,
                          UINT   uiMsg,
                          WPARAM wParam,
                          LPARAM lParam,
                          PVOID  pUser);

LRESULT WINAPI SbsWmActivate (HWND   hWnd,
                              UINT   uiMsg,
                              WPARAM wParam,
                              LPARAM lParam,
                              PVOID  pUser);

LRESULT WINAPI SbsWmNcPaint (HWND   hWnd,
                             UINT   uiMsg,
                             WPARAM wParam,
                             LPARAM lParam,
                             PVOID  pUser);

LRESULT WINAPI SbsWmLButtonDown (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmQueryOpen (HWND   hWnd,
                               UINT   uiMsg,
                               WPARAM wParam,
                               LPARAM lParam,
                               PVOID  pUser);

LRESULT WINAPI SbsWmPaletteChanged (HWND   hWnd,
                                    UINT   uiMsg,
                                    WPARAM wParam,
                                    LPARAM lParam,
                                    PVOID  pUser);

LRESULT WINAPI SbsWmQueryNewPalette (HWND   hWnd,
                                     UINT   uiMsg,
                                     WPARAM wParam,
                                     LPARAM lParam,
                                     PVOID  pUser);

LRESULT WINAPI SbsWmCtlColorDlg (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmCtlColorStatic (HWND   hWnd,
                                    UINT   uiMsg,
                                    WPARAM wParam,
                                    LPARAM lParam,
                                    PVOID  pUser);

LRESULT WINAPI SbsWmCtlColorEdit (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam,
                                  PVOID  pUser);

LRESULT WINAPI SbsWmCtlColorListBox (HWND   hWnd,
                                     UINT   uiMsg,
                                     WPARAM wParam,
                                     LPARAM lParam,
                                     PVOID  pUser);

LRESULT WINAPI SbsWmCtlColorBtn (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmCtlColor (HWND   hWnd,
                              UINT   uiMsg,
                              WPARAM wParam,
                              LPARAM lParam,
                              PVOID  pUser);

LRESULT WINAPI SbsWmCommandExit (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmCommandFont (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmCommandColor (HWND   hWnd,
                                  UINT   uiMsg,
                                  WPARAM wParam,
                                  LPARAM lParam,
                                  PVOID  pUser);

LRESULT WINAPI SbsWmCommandHelp (HWND   hWnd,
                                 UINT   uiMsg,
                                 WPARAM wParam,
                                 LPARAM lParam,
                                 PVOID  pUser);

LRESULT WINAPI SbsWmAppTimer (HWND   hWnd,
                              UINT   uiMsg,
                              WPARAM wParam,
                              LPARAM lParam,
                              PVOID  pUser);

LRESULT WINAPI SbsWmDefault (HWND   hWnd,
                             UINT   uiMsg,
                             WPARAM wParam,
                             LPARAM lParam,
                             PVOID  pUser);

BOOL WINAPI SbsDrawShades (PCOLORREF   pcr,
                           PSBS_SHADES pss);

DWORD WINAPI SbsDrawStyle (DWORD dFlags,
                           DWORD dLeft,
                           DWORD dRight,
                           DWORD dTop,
                           DWORD dBottom);

BOOL WINAPI SbsDrawMargins (DWORD  dStyle,
                            PDWORD pdLeft,
                            PDWORD pdRight,
                            PDWORD pdTop,
                            PDWORD pdBottom);

BOOL WINAPI SbsDrawNormalize (LONG  lX,
                              LONG  lY,
                              LONG  lWidth,
                              LONG  lHeight,
                              PRECT pr);

BOOL WINAPI SbsDrawNormalizeEx (LONG  lX,
                                LONG  lY,
                                LONG  lWidth,
                                LONG  lHeight,
                                PRECT pr,
                                DWORD dStyle);

BOOL WINAPI SbsDrawTest (PRECT pr,
                         DWORD dPixels);

LONG WINAPI SbsDrawMetricsA (HDC   hDC,
                             PLONG plTop,
                             PLONG plBottom);

LONG WINAPI SbsDrawMetricsW (HDC   hDC,
                             PLONG plTop,
                             PLONG plBottom);

BOOL WINAPI SbsDrawLine (HDC      hDC,
                         COLORREF cr,
                         LONG     lX,
                         LONG     lY,
                         LONG     lLength,
                         BOOL     fVertical);

BOOL WINAPI SbsDrawAngle (HDC      hDC,
                          COLORREF cr,
                          LONG     lX,
                          LONG     lY,
                          LONG     lWidth,
                          LONG     lHeight);

BOOL WINAPI SbsDrawRectangle (HDC      hDC,
                              COLORREF cr,
                              LONG     lX,
                              LONG     lY,
                              LONG     lWidth,
                              LONG     lHeight,
                              BOOL     fFill);

BOOL WINAPI SbsDrawSingle (HDC      hDC,
                           COLORREF crLeftTop,
                           COLORREF crRightBottom,
                           LONG     lX,
                           LONG     lY,
                           LONG     lWidth,
                           LONG     lHeight);

BOOL WINAPI SbsDrawDouble (HDC      hDC,
                           COLORREF crLeftTopOuter,
                           COLORREF crLeftTopInner,
                           COLORREF crRightBottomInner,
                           COLORREF crRightBottomOuter,
                           LONG     lX,
                           LONG     lY,
                           LONG     lWidth,
                           LONG     lHeight);

BOOL WINAPI SbsDrawFrame (HDC       hDC,
                          PCOLORREF pcr,
                          LONG      lX,
                          LONG      lY,
                          LONG      lWidth,
                          LONG      lHeight,
                          BOOL      fFlat,
                          BOOL      fPopOut);

BOOL WINAPI SbsDrawArea (HDC       hDC,
                         PCOLORREF pcr,
                         LONG      lX,
                         LONG      lY,
                         LONG      lWidth,
                         LONG      lHeight,
                         BOOL      fFlat,
                         BOOL      fPopOut);

BOOL WINAPI SbsDrawBitmap (HDC     hDC,
                           HBITMAP hBitmap,
                           LONG    lX,
                           LONG    lY,
                           LONG    lWidth,
                           LONG    lHeight);

BOOL WINAPI SbsDrawTextA (HDC       hDC,
                          PBYTE     pbText,
                          PCOLORREF pcr,
                          LONG      lX,
                          LONG      lY,
                          LONG      lWidth,
                          LONG      lHeight,
                          DWORD     dStyle);

BOOL WINAPI SbsDrawTextW (HDC       hDC,
                          PWORD     pwText,
                          PCOLORREF pcr,
                          LONG      lX,
                          LONG      lY,
                          LONG      lWidth,
                          LONG      lHeight,
                          DWORD     dStyle);

BOOL WINAPI SbsDrawBoxA (HDC       hDC,
                         HBITMAP   hBitmap,
                         PBYTE     pbText,
                         PCOLORREF pcrText,
                         PCOLORREF pcrArea,
                         LONG      lX,
                         LONG      lY,
                         LONG      lWidth,
                         LONG      lHeight,
                         DWORD     dStyle);

BOOL WINAPI SbsDrawBoxW (HDC       hDC,
                         HBITMAP   hBitmap,
                         PWORD     pwText,
                         PCOLORREF pcrText,
                         PCOLORREF pcrArea,
                         LONG      lX,
                         LONG      lY,
                         LONG      lWidth,
                         LONG      lHeight,
                         DWORD     dStyle);

BOOL WINAPI SbsDrawButtonA (HDC       hDC,
                            HBITMAP   hBitmap,
                            PBYTE     pbText,
                            PCOLORREF pcrText,
                            PCOLORREF pcrArea,
                            LONG      lX,
                            LONG      lY,
                            LONG      lWidth,
                            LONG      lHeight,
                            BOOL      fClicked);

BOOL WINAPI SbsDrawButtonW (HDC       hDC,
                            HBITMAP   hBitmap,
                            PWORD     pwText,
                            PCOLORREF pcrText,
                            PCOLORREF pcrArea,
                            LONG      lX,
                            LONG      lY,
                            LONG      lWidth,
                            LONG      lHeight,
                            BOOL      fClicked);

BOOL WINAPI SbsDrawInfoA (HDC       hDC,
                          HBITMAP   hBitmap,
                          HICON     hIcon,
                          PBYTE     pbText,
                          PCOLORREF pcrText,
                          PCOLORREF pcrArea,
                          LONG      lX,
                          LONG      lY,
                          LONG      lWidth,
                          LONG      lHeight,
                          BOOL      fCenter);

BOOL WINAPI SbsDrawInfoW (HDC       hDC,
                          HBITMAP   hBitmap,
                          HICON     hIcon,
                          PWORD     pwText,
                          PCOLORREF pcrText,
                          PCOLORREF pcrArea,
                          LONG      lX,
                          LONG      lY,
                          LONG      lWidth,
                          LONG      lHeight,
                          BOOL      fCenter);

HBRUSH WINAPI SbsBrushDelete (HBRUSH hBrush);

HFONT WINAPI SbsFontDelete (HFONT hFont);

HFONT WINAPI SbsFontObjectA (PLOGFONTA plfA,
                             PBYTE     pbName,
                             LONG      lHeight,
                             BOOL      fBold,
                             BOOL      fItalic,
                             BOOL      fCreate);

HFONT WINAPI SbsFontObjectW (PLOGFONTW plfW,
                             PWORD     pwName,
                             LONG      lHeight,
                             BOOL      fBold,
                             BOOL      fItalic,
                             BOOL      fCreate);

HFONT WINAPI SbsFontSystemA (PLOGFONTA plfA,
                             BOOL      fCreate);

HFONT WINAPI SbsFontSystemW (PLOGFONTW plfW,
                             BOOL      fCreate);

HFONT WINAPI SbsFontFixedsysA (PLOGFONTA plfA,
                               BOOL      fCreate);

HFONT WINAPI SbsFontFixedsysW (PLOGFONTW plfW,
                               BOOL      fCreate);

HFONT WINAPI SbsFontTerminalA (PLOGFONTA plfA,
                               BOOL      fCreate);

HFONT WINAPI SbsFontTerminalW (PLOGFONTW plfW,
                               BOOL      fCreate);

HFONT WINAPI SbsFontSymbolA (PLOGFONTA plfA,
                             BOOL      fCreate);

HFONT WINAPI SbsFontSymbolW (PLOGFONTW plfW,
                             BOOL      fCreate);

HFONT WINAPI SbsFontStandardA (PLOGFONTA plfA,
                               DWORD     dSize,
                               BOOL      fBold,
                               BOOL      fItalic,
                               BOOL      fNarrow,
                               BOOL      fCreate);

HFONT WINAPI SbsFontStandardW (PLOGFONTW plfW,
                               DWORD     dSize,
                               BOOL      fBold,
                               BOOL      fItalic,
                               BOOL      fNarrow,
                               BOOL      fCreate);

HFONT WINAPI SbsFontDefault (DWORD dFont);

BOOL WINAPI SbsFontConvert (PLOGFONTA plfA,
                            PLOGFONTW plfW,
                            BOOL      fToAnsi);

BOOL WINAPI SbsFontCodeA (HWND hWnd,
                          BOOL fFixed);

BOOL WINAPI SbsFontCodeW (HWND hWnd,
                          BOOL fFixed);

VOID WINAPI SbsTimeNow (PSBS_TIME pst);

DWORD WINAPI SbsTimePack (PSBS_TIME pst);

VOID WINAPI SbsTimeUnpack (PSBS_TIME pst,
                           DWORD     dTime);

DWORD WINAPI SbsTimeDayOfYear (DWORD dDay,
                               DWORD dMonth,
                               DWORD dYear);

PBYTE WINAPI SbsTimeTextA (PSYSTEMTIME pst,
                           BOOL        fGerman);

PWORD WINAPI SbsTimeTextW (PSYSTEMTIME pst,
                           BOOL        fGerman);

PBYTE WINAPI SbsTimeTextUtcA (PFILETIME pft,
                              BOOL      fGerman);

PWORD WINAPI SbsTimeTextUtcW (PFILETIME pft,
                              BOOL      fGerman);

PBYTE WINAPI SbsTimeTextLocalA (PFILETIME pft,
                                BOOL      fGerman);

PWORD WINAPI SbsTimeTextLocalW (PFILETIME pft,
                                BOOL      fGerman);

PVOID WINAPI SbsTimeTextEx (PVOID pTime,
                            BOOL  fGerman,
                            BOOL  fFileTime,
                            BOOL  fLocal,
                            BOOL  fUnicode);

PBYTE WINAPI SbsGuidTextA (PGUID pGuid);

PWORD WINAPI SbsGuidTextW (PGUID pGuid);

PBYTE WINAPI SbsGuidTextExA (PGUID pGuid,
                             PBYTE pbFormat);

PWORD WINAPI SbsGuidTextExW (PGUID pGuid,
                             PWORD pwFormat);

BOOL WINAPI SbsGuidBinaryA (PBYTE pbGuid,
                            PGUID pGuid);

BOOL WINAPI SbsGuidBinaryW (PWORD pwGuid,
                            PGUID pGuid);

BOOL WINAPI SbsGuidValueReadA (PGUID pGuid,
                               PBYTE pbFormat,
                               PBYTE pbItem);

BOOL WINAPI SbsGuidValueReadW (PGUID pGuid,
                               PWORD pwFormat,
                               PWORD pwItem);

BOOL WINAPI SbsGuidValueWriteA (PGUID pGuid,
                                PBYTE pbFormat,
                                PBYTE pbItem);

BOOL WINAPI SbsGuidValueWriteW (PGUID pGuid,
                                PWORD pwFormat,
                                PWORD pwItem);

PBYTE WINAPI SbsGuidReadTextA (PGUID pGuid,
                               PBYTE pbFormat);

PWORD WINAPI SbsGuidReadTextW (PGUID pGuid,
                               PWORD pwFormat);

BOOL WINAPI SbsGuidWriteTextA (PGUID pGuid,
                               PBYTE pbFormat,
                               PBYTE pbData);

BOOL WINAPI SbsGuidWriteTextW (PGUID pGuid,
                               PWORD pwFormat,
                               PWORD pwData);

BOOL WINAPI SbsGuidDeleteKeyA (PGUID pGuid,
                               PBYTE pbFormat);

BOOL WINAPI SbsGuidDeleteKeyW (PGUID pGuid,
                               PWORD pwFormat);

BOOL WINAPI SbsGuidDeleteValueA (PGUID pGuid,
                                 PBYTE pbFormat);

BOOL WINAPI SbsGuidDeleteValueW (PGUID pGuid,
                                 PWORD pwFormat);

DWORD WINAPI SbsCrc32Start (PDWORD pdCrc32);

BOOL WINAPI SbsCrc32Stop (PDWORD pdCrc32);

DWORD WINAPI SbsCrc32Byte (PDWORD pdCrc32,
                           BYTE   bData);

DWORD WINAPI SbsCrc32Word (PDWORD pdCrc32,
                           WORD   wData);

DWORD WINAPI SbsCrc32Dword (PDWORD pdCrc32,
                            DWORD  dData);

DWORD WINAPI SbsCrc32CharA (PDWORD pdCrc32,
                            BYTE   bData);

DWORD WINAPI SbsCrc32CharW (PDWORD pdCrc32,
                            WORD   wData);

DWORD WINAPI SbsCrc32Multi (PDWORD pdCrc32,
                            PVOID  pData,
                            DWORD  dData);

DWORD WINAPI SbsCrc32TextA (PDWORD pdCrc32,
                            PBYTE  pbData,
                            DWORD  dData);

DWORD WINAPI SbsCrc32TextW (PDWORD pdCrc32,
                            PWORD  pwData,
                            DWORD  dData);

DWORD WINAPI SbsRandomInitialize (PDWORD pdData,
                                  PDWORD pdAddr,
                                  DWORD  dSeed);

BYTE WINAPI SbsRandomByte (PDWORD pdData,
                           PDWORD pdAddr);

WORD WINAPI SbsRandomWord (PDWORD pdData,
                           PDWORD pdAddr);

DWORD WINAPI SbsRandomDword (PDWORD pdData,
                             PDWORD pdAddr);

DWORD WINAPI SbsRandomTextA (PDWORD pdData,
                             PDWORD pdAddr,
                             PBYTE  pbBuffer,
                             DWORD  dBuffer,
                             DWORD  dNumeric);

DWORD WINAPI SbsRandomTextW (PDWORD pdData,
                             PDWORD pdAddr,
                             PWORD  pwBuffer,
                             DWORD  dBuffer,
                             DWORD  dNumeric);

HSCM WINAPI SbsServiceConnect (VOID);

HSCM WINAPI SbsServiceDisconnect (HSCM hScm);

HSCM WINAPI SbsServiceManager (HSCM hPermanent,
                               HSCM hTransient);

SC_HANDLE WINAPI SbsServiceOpen (HSCM  hScm,
                                 PWORD pwName);

SC_HANDLE WINAPI SbsServiceClose (HSCM      hScm,
                                  SC_HANDLE hService);

BOOL WINAPI SbsServiceLoad (HSCM  hScm,
                            PWORD pwName,
                            PWORD pwInfo,
                            PWORD pwPath,
                            DWORD dType,
                            DWORD dStart,
                            BOOL  fStart);

BOOL WINAPI SbsServiceUnload (HSCM  hScm,
                              PWORD pwName);

BOOL WINAPI SbsServiceStart (HSCM  hScm,
                             PWORD pwName);

BOOL WINAPI SbsServiceControl (HSCM  hScm,
                               PWORD pwName,
                               DWORD dControl);

BOOL WINAPI SbsServiceStop (HSCM  hScm,
                            PWORD pwName);

BOOL WINAPI SbsServicePause (HSCM  hScm,
                             PWORD pwName);

BOOL WINAPI SbsServiceContinue (HSCM  hScm,
                                PWORD pwName);

DWORD WINAPI SbsRtlVersion (VOID);

DWORD WINAPI SbsRtlVersionTestA (DWORD        dRequired,
                                 PSBS_VERSION psv);

DWORD WINAPI SbsRtlVersionTestW (DWORD        dRequired,
                                 PSBS_VERSION psv);

// -----------------------------------------------------------------

#ifdef __cplusplus
}
#endif

// =================================================================
// LINKER CONTROL
// =================================================================

#ifdef  _SBS_RTL_DLL_

#pragma comment (linker, "/entry:\"DllMain\"")
#pragma comment (linker, "/defaultlib:version.lib")
#pragma comment (linker, "/defaultlib:comctl32.lib")
#pragma comment (linker, "/defaultlib:wininet.lib")

#else   // #ifdef _SBS_RTL_DLL_

#pragma comment (linker, "/defaultlib:sbs_rtl.lib")

#endif  // #ifdef _SBS_RTL_DLL_

// =================================================================
// RUNTIME LIBRARIES
// =================================================================

#include <SbsPrint.h>
#include <SbsNum.h>

////////////////////////////////////////////////////////////////////
#endif // #ifndef _RC_PASS_
////////////////////////////////////////////////////////////////////

// =================================================================
// END OF FILE
// =================================================================
